/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.net;

import cn.jiguang.bd.d;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLTrustManager
implements X509TrustManager {
    private X509TrustManager a;

    public SSLTrustManager(String string) {
        try {
            TrustManager[] trustManagerArray;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            ((InputStream)byteArrayInputStream).close();
            KeyStore.TrustedCertificateEntry trustedCertificateEntry = new KeyStore.TrustedCertificateEntry(x509Certificate);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setEntry("ca_root", trustedCertificateEntry, null);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            for (TrustManager trustManager : trustManagerArray = trustManagerFactory.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                this.a = (X509TrustManager)trustManager;
                return;
            }
        }
        catch (Throwable throwable) {
            d.g("SSLTrustManager", "init trustManager failed, error:" + throwable);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        d.c("SSLTrustManager", "checkClientTrusted");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        d.c("SSLTrustManager", "checkServerTrusted");
        if (x509CertificateArray == null || x509CertificateArray.length == 0 || x509CertificateArray[0] == null) {
            throw new CertificateException("Check Server x509Certificates is empty");
        }
        try {
            x509CertificateArray[0].checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            d.g("SSLTrustManager", "checkServerTrusted: CertificateExpiredException:" + certificateExpiredException.getLocalizedMessage());
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            d.g("SSLTrustManager", "checkServerTrusted: CertificateNotYetValidException:" + certificateNotYetValidException.getLocalizedMessage());
        }
        catch (Throwable throwable) {
            d.g("SSLTrustManager", "checkServerTrusted failed, error" + throwable.getLocalizedMessage());
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        d.c("SSLTrustManager", "getAcceptedIssuers");
        return this.a.getAcceptedIssuers();
    }
}

