/*
 * Decompiled with CFR 0.152.
 */
package com.android.signapk;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.encoders.Base64;

class SignApk {
    private static final String CERT_SF_NAME = "META-INF/CERT.SF";
    private static final String CERT_SIG_NAME = "META-INF/CERT.%s";
    private static final String CERT_SF_MULTI_NAME = "META-INF/CERT%d.SF";
    private static final String CERT_SIG_MULTI_NAME = "META-INF/CERT%d.%s";
    private static final String OTACERT_NAME = "META-INF/com/android/otacert";
    private static Provider sBouncyCastleProvider;
    private static final int USE_SHA1 = 1;
    private static final int USE_SHA256 = 2;
    private static Pattern stripPattern;

    SignApk() {
    }

    private static int getDigestAlgorithm(X509Certificate cert) {
        String sigAlg = cert.getSigAlgName().toUpperCase(Locale.US);
        if ("SHA1WITHRSA".equals(sigAlg) || "MD5WITHRSA".equals(sigAlg)) {
            return 1;
        }
        if (sigAlg.startsWith("SHA256WITH")) {
            return 2;
        }
        throw new IllegalArgumentException("unsupported signature algorithm \"" + sigAlg + "\" in cert [" + cert.getSubjectDN());
    }

    private static String getSignatureAlgorithm(X509Certificate cert) {
        String sigAlg = cert.getSigAlgName().toUpperCase(Locale.US);
        String keyType = cert.getPublicKey().getAlgorithm().toUpperCase(Locale.US);
        if ("RSA".equalsIgnoreCase(keyType)) {
            if (SignApk.getDigestAlgorithm(cert) == 2) {
                return "SHA256withRSA";
            }
            return "SHA1withRSA";
        }
        if ("EC".equalsIgnoreCase(keyType)) {
            return "SHA256withECDSA";
        }
        throw new IllegalArgumentException("unsupported key type: " + keyType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate readPublicKey(File file) throws IOException, GeneralSecurityException {
        try (FileInputStream input = new FileInputStream(file);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(input);
            return x509Certificate;
        }
    }

    private static String readPassword(File keyFile) {
        System.out.print("Enter password for " + keyFile + " (password will not be hidden): ");
        System.out.flush();
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            return stdin.readLine();
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static PKCS8EncodedKeySpec decryptPrivateKey(byte[] encryptedPrivateKey, File keyFile) throws GeneralSecurityException {
        EncryptedPrivateKeyInfo epkInfo;
        try {
            epkInfo = new EncryptedPrivateKeyInfo(encryptedPrivateKey);
        }
        catch (IOException ex) {
            return null;
        }
        char[] password = SignApk.readPassword(keyFile).toCharArray();
        SecretKeyFactory skFactory = SecretKeyFactory.getInstance(epkInfo.getAlgName());
        SecretKey key = skFactory.generateSecret(new PBEKeySpec(password));
        Cipher cipher = Cipher.getInstance(epkInfo.getAlgName());
        cipher.init(2, (Key)key, epkInfo.getAlgParameters());
        try {
            return epkInfo.getKeySpec(cipher);
        }
        catch (InvalidKeySpecException ex) {
            System.err.println("signapk: Password for " + keyFile + " may be bad.");
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey readPrivateKey(File file) throws IOException, GeneralSecurityException {
        try (DataInputStream input = new DataInputStream(new FileInputStream(file));){
            byte[] bytes = new byte[(int)file.length()];
            input.read(bytes);
            PKCS8EncodedKeySpec spec = SignApk.decryptPrivateKey(bytes, file);
            if (spec == null) {
                spec = new PKCS8EncodedKeySpec(bytes);
            }
            ASN1InputStream bIn = new ASN1InputStream(new ByteArrayInputStream(spec.getEncoded()));
            PrivateKeyInfo pki = PrivateKeyInfo.getInstance(bIn.readObject());
            String algOid = pki.getPrivateKeyAlgorithm().getAlgorithm().getId();
            PrivateKey privateKey = KeyFactory.getInstance(algOid).generatePrivate(spec);
            return privateKey;
        }
    }

    private static Manifest addDigestsToManifest(JarFile jar, int hashes) throws IOException, GeneralSecurityException {
        Manifest input = jar.getManifest();
        Manifest output = new Manifest();
        Attributes main = output.getMainAttributes();
        if (input != null) {
            main.putAll((Map<?, ?>)input.getMainAttributes());
        } else {
            main.putValue("Manifest-Version", "1.0");
            main.putValue("Created-By", "1.0 (Android SignApk)");
        }
        MessageDigest md_sha1 = null;
        MessageDigest md_sha256 = null;
        if ((hashes & 1) != 0) {
            md_sha1 = MessageDigest.getInstance("SHA1");
        }
        if ((hashes & 2) != 0) {
            md_sha256 = MessageDigest.getInstance("SHA256");
        }
        byte[] buffer = new byte[4096];
        TreeMap<String, JarEntry> byName = new TreeMap<String, JarEntry>();
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            byName.put(entry.getName(), entry);
        }
        for (JarEntry entry : byName.values()) {
            int num;
            String name = entry.getName();
            if (entry.isDirectory() || stripPattern != null && stripPattern.matcher(name).matches()) continue;
            InputStream data = jar.getInputStream(entry);
            while ((num = data.read(buffer)) > 0) {
                if (md_sha1 != null) {
                    md_sha1.update(buffer, 0, num);
                }
                if (md_sha256 == null) continue;
                md_sha256.update(buffer, 0, num);
            }
            Attributes attr = null;
            if (input != null) {
                attr = input.getAttributes(name);
            }
            Attributes attributes = attr = attr != null ? new Attributes(attr) : new Attributes();
            if (md_sha1 != null) {
                attr.putValue("SHA1-Digest", new String(Base64.encode(md_sha1.digest()), "ASCII"));
            }
            if (md_sha256 != null) {
                attr.putValue("SHA-256-Digest", new String(Base64.encode(md_sha256.digest()), "ASCII"));
            }
            output.getEntries().put(name, attr);
        }
        return output;
    }

    private static void addOtacert(JarOutputStream outputJar, File publicKeyFile, long timestamp, Manifest manifest, int hash) throws IOException, GeneralSecurityException {
        int read;
        MessageDigest md = MessageDigest.getInstance(hash == 1 ? "SHA1" : "SHA256");
        JarEntry je = new JarEntry(OTACERT_NAME);
        je.setTime(timestamp);
        outputJar.putNextEntry(je);
        FileInputStream input = new FileInputStream(publicKeyFile);
        byte[] b = new byte[4096];
        while ((read = input.read(b)) != -1) {
            outputJar.write(b, 0, read);
            md.update(b, 0, read);
        }
        input.close();
        Attributes attr = new Attributes();
        attr.putValue(hash == 1 ? "SHA1-Digest" : "SHA-256-Digest", new String(Base64.encode(md.digest()), "ASCII"));
        manifest.getEntries().put(OTACERT_NAME, attr);
    }

    private static void writeSignatureFile(Manifest manifest, OutputStream out, int hash) throws IOException, GeneralSecurityException {
        Manifest sf = new Manifest();
        Attributes main = sf.getMainAttributes();
        main.putValue("Signature-Version", "1.0");
        main.putValue("Created-By", "1.0 (Android SignApk)");
        MessageDigest md = MessageDigest.getInstance(hash == 2 ? "SHA256" : "SHA1");
        PrintStream print = new PrintStream((OutputStream)new DigestOutputStream(new ByteArrayOutputStream(), md), true, "UTF-8");
        manifest.write(print);
        print.flush();
        main.putValue(hash == 2 ? "SHA-256-Digest-Manifest" : "SHA1-Digest-Manifest", new String(Base64.encode(md.digest()), "ASCII"));
        Map<String, Attributes> entries = manifest.getEntries();
        for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
            print.print("Name: " + entry.getKey() + "\r\n");
            for (Map.Entry<Object, Object> att : entry.getValue().entrySet()) {
                print.print(att.getKey() + ": " + att.getValue() + "\r\n");
            }
            print.print("\r\n");
            print.flush();
            Attributes sfAttr = new Attributes();
            sfAttr.putValue(hash == 2 ? "SHA-256-Digest" : "SHA1-Digest-Manifest", new String(Base64.encode(md.digest()), "ASCII"));
            sf.getEntries().put(entry.getKey(), sfAttr);
        }
        CountOutputStream cout = new CountOutputStream(out);
        sf.write(cout);
        if (cout.size() % 1024 == 0) {
            cout.write(13);
            cout.write(10);
        }
    }

    private static void writeSignatureBlock(CMSTypedData data, X509Certificate publicKey, PrivateKey privateKey, OutputStream out) throws IOException, CertificateEncodingException, OperatorCreationException, CMSException {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>(1);
        certList.add(publicKey);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner signer = new JcaContentSignerBuilder(SignApk.getSignatureAlgorithm(publicKey)).setProvider(sBouncyCastleProvider).build(privateKey);
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(sBouncyCastleProvider).build()).setDirectSignature(true).build(signer, publicKey));
        gen.addCertificates(certs);
        CMSSignedData sigData = gen.generate(data, false);
        ASN1InputStream asn1 = new ASN1InputStream(sigData.getEncoded());
        DEROutputStream dos = new DEROutputStream(out);
        dos.writeObject(asn1.readObject());
    }

    private static void copyFiles(Manifest manifest, JarFile in, JarOutputStream out, long timestamp, int alignment) throws IOException {
        int num;
        InputStream data;
        JarEntry outEntry;
        JarEntry inEntry;
        byte[] buffer = new byte[4096];
        Map<String, Attributes> entries = manifest.getEntries();
        ArrayList<String> names = new ArrayList<String>(entries.keySet());
        Collections.sort(names);
        boolean firstEntry = true;
        long offset = 0L;
        for (String name : names) {
            inEntry = in.getJarEntry(name);
            outEntry = null;
            if (inEntry.getMethod() != 0) continue;
            outEntry = new JarEntry(inEntry);
            outEntry.setTime(timestamp);
            offset += (long)(30 + outEntry.getName().length());
            if (firstEntry) {
                offset += 4L;
                firstEntry = false;
            }
            if (alignment > 0 && offset % (long)alignment != 0L) {
                int needed = alignment - (int)(offset % (long)alignment);
                outEntry.setExtra(new byte[needed]);
                offset += (long)needed;
            }
            out.putNextEntry(outEntry);
            data = in.getInputStream(inEntry);
            while ((num = data.read(buffer)) > 0) {
                out.write(buffer, 0, num);
                offset += (long)num;
            }
            out.flush();
        }
        for (String name : names) {
            inEntry = in.getJarEntry(name);
            outEntry = null;
            if (inEntry.getMethod() == 0) continue;
            outEntry = new JarEntry(name);
            outEntry.setTime(timestamp);
            out.putNextEntry(outEntry);
            data = in.getInputStream(inEntry);
            while ((num = data.read(buffer)) > 0) {
                out.write(buffer, 0, num);
            }
            out.flush();
        }
    }

    private static void signWholeFile(JarFile inputJar, File publicKeyFile, X509Certificate publicKey, PrivateKey privateKey, OutputStream outputStream) throws Exception {
        CMSSigner cmsOut = new CMSSigner(inputJar, publicKeyFile, publicKey, privateKey, outputStream);
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        byte[] message = "signed by SignApk".getBytes("UTF-8");
        temp.write(message);
        temp.write(0);
        cmsOut.writeSignatureBlock(temp);
        byte[] zipData = cmsOut.getSigner().getTail();
        if (zipData[zipData.length - 22] != 80 || zipData[zipData.length - 21] != 75 || zipData[zipData.length - 20] != 5 || zipData[zipData.length - 19] != 6) {
            throw new IllegalArgumentException("zip data already has an archive comment");
        }
        int total_size = temp.size() + 6;
        if (total_size > 65535) {
            throw new IllegalArgumentException("signature is too big for ZIP file comment");
        }
        int signature_start = total_size - message.length - 1;
        temp.write(signature_start & 0xFF);
        temp.write(signature_start >> 8 & 0xFF);
        temp.write(255);
        temp.write(255);
        temp.write(total_size & 0xFF);
        temp.write(total_size >> 8 & 0xFF);
        temp.flush();
        byte[] b = temp.toByteArray();
        for (int i = 0; i < b.length - 3; ++i) {
            if (b[i] != 80 || b[i + 1] != 75 || b[i + 2] != 5 || b[i + 3] != 6) continue;
            throw new IllegalArgumentException("found spurious EOCD header at " + i);
        }
        outputStream.write(total_size & 0xFF);
        outputStream.write(total_size >> 8 & 0xFF);
        temp.writeTo(outputStream);
    }

    private static void signFile(Manifest manifest, JarFile inputJar, X509Certificate[] publicKey, PrivateKey[] privateKey, JarOutputStream outputJar) throws Exception {
        long timestamp = publicKey[0].getNotBefore().getTime() + 3600000L;
        JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
        je.setTime(timestamp);
        outputJar.putNextEntry(je);
        manifest.write(outputJar);
        int numKeys = publicKey.length;
        for (int k = 0; k < numKeys; ++k) {
            je = new JarEntry(numKeys == 1 ? CERT_SF_NAME : String.format(CERT_SF_MULTI_NAME, k));
            je.setTime(timestamp);
            outputJar.putNextEntry(je);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SignApk.writeSignatureFile(manifest, baos, SignApk.getDigestAlgorithm(publicKey[k]));
            byte[] signedData = baos.toByteArray();
            outputJar.write(signedData);
            String keyType = publicKey[k].getPublicKey().getAlgorithm();
            je = new JarEntry(numKeys == 1 ? String.format(CERT_SIG_NAME, keyType) : String.format(CERT_SIG_MULTI_NAME, k, keyType));
            je.setTime(timestamp);
            outputJar.putNextEntry(je);
            SignApk.writeSignatureBlock(new CMSProcessableByteArray(signedData), publicKey[k], privateKey[k], outputJar);
        }
    }

    private static void loadProviderIfNecessary(String providerClassName) {
        Object o;
        Class<?> klass;
        if (providerClassName == null) {
            return;
        }
        try {
            ClassLoader sysLoader = ClassLoader.getSystemClassLoader();
            klass = sysLoader != null ? sysLoader.loadClass(providerClassName) : Class.forName(providerClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
        Constructor<?> constructor = null;
        for (Constructor<?> c : klass.getConstructors()) {
            if (c.getParameterTypes().length != 0) continue;
            constructor = c;
            break;
        }
        if (constructor == null) {
            System.err.println("No zero-arg constructor found for " + providerClassName);
            System.exit(1);
            return;
        }
        try {
            o = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
        if (!(o instanceof Provider)) {
            System.err.println("Not a Provider class: " + providerClassName);
            System.exit(1);
        }
        Security.insertProviderAt((Provider)o, 1);
    }

    private static void usage() {
        System.err.println("Usage: signapk [-w] [-a <alignment>] [-providerClass <className>] publickey.x509[.pem] privatekey.pk8 [publickey2.x509[.pem] privatekey2.pk8 ...] input.jar output.jar");
        System.exit(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 4) {
            SignApk.usage();
        }
        sBouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider(sBouncyCastleProvider);
        boolean signWholeFile = false;
        String providerClass = null;
        Object providerArg = null;
        int alignment = 4;
        int argstart = 0;
        while (argstart < args.length && args[argstart].startsWith("-")) {
            if ("-w".equals(args[argstart])) {
                signWholeFile = true;
                ++argstart;
                continue;
            }
            if ("-providerClass".equals(args[argstart])) {
                if (argstart + 1 >= args.length) {
                    SignApk.usage();
                }
                providerClass = args[++argstart];
                ++argstart;
                continue;
            }
            if ("-a".equals(args[argstart])) {
                alignment = Integer.parseInt(args[++argstart]);
                ++argstart;
                continue;
            }
            SignApk.usage();
        }
        if ((args.length - argstart) % 2 == 1) {
            SignApk.usage();
        }
        int numKeys = (args.length - argstart) / 2 - 1;
        if (signWholeFile && numKeys > 1) {
            System.err.println("Only one key may be used with -w.");
            System.exit(2);
        }
        SignApk.loadProviderIfNecessary(providerClass);
        String inputFilename = args[args.length - 2];
        String outputFilename = args[args.length - 1];
        ZipFile inputJar = null;
        FileOutputStream outputFile = null;
        int hashes = 0;
        try {
            File firstPublicKeyFile = new File(args[argstart + 0]);
            X509Certificate[] publicKey = new X509Certificate[numKeys];
            try {
                for (int i = 0; i < numKeys; ++i) {
                    int argNum = argstart + i * 2;
                    publicKey[i] = SignApk.readPublicKey(new File(args[argNum]));
                    hashes |= SignApk.getDigestAlgorithm(publicKey[i]);
                }
            }
            catch (IllegalArgumentException e) {
                System.err.println(e);
                System.exit(1);
            }
            long timestamp = publicKey[0].getNotBefore().getTime() + 3600000L;
            PrivateKey[] privateKey = new PrivateKey[numKeys];
            for (int i = 0; i < numKeys; ++i) {
                int argNum = argstart + i * 2 + 1;
                privateKey[i] = SignApk.readPrivateKey(new File(args[argNum]));
            }
            inputJar = new JarFile(new File(inputFilename), false);
            outputFile = new FileOutputStream(outputFilename);
            if (signWholeFile) {
                SignApk.signWholeFile((JarFile)inputJar, firstPublicKeyFile, publicKey[0], privateKey[0], outputFile);
            } else {
                JarOutputStream outputJar = new JarOutputStream(outputFile);
                outputJar.setLevel(9);
                Manifest manifest = SignApk.addDigestsToManifest((JarFile)inputJar, hashes);
                SignApk.copyFiles(manifest, (JarFile)inputJar, outputJar, timestamp, alignment);
                SignApk.signFile(manifest, (JarFile)inputJar, publicKey, privateKey, outputJar);
                outputJar.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            try {
                if (inputJar != null) {
                    inputJar.close();
                }
                if (outputFile != null) {
                    outputFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    static {
        stripPattern = Pattern.compile("^(META-INF/((.*)[.](SF|RSA|DSA|EC)|com/android/otacert))|(" + Pattern.quote("META-INF/MANIFEST.MF") + ")$");
    }

    private static class CMSSigner
    implements CMSTypedData {
        private JarFile inputJar;
        private File publicKeyFile;
        private X509Certificate publicKey;
        private PrivateKey privateKey;
        private String outputFile;
        private OutputStream outputStream;
        private final ASN1ObjectIdentifier type;
        private WholeFileSignerOutputStream signer;

        public CMSSigner(JarFile inputJar, File publicKeyFile, X509Certificate publicKey, PrivateKey privateKey, OutputStream outputStream) {
            this.inputJar = inputJar;
            this.publicKeyFile = publicKeyFile;
            this.publicKey = publicKey;
            this.privateKey = privateKey;
            this.outputStream = outputStream;
            this.type = new ASN1ObjectIdentifier(CMSObjectIdentifiers.data.getId());
        }

        @Override
        public Object getContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ASN1ObjectIdentifier getContentType() {
            return this.type;
        }

        @Override
        public void write(OutputStream out) throws IOException {
            try {
                this.signer = new WholeFileSignerOutputStream(out, this.outputStream);
                JarOutputStream outputJar = new JarOutputStream(this.signer);
                int hash = SignApk.getDigestAlgorithm(this.publicKey);
                long timestamp = this.publicKey.getNotBefore().getTime() + 3600000L;
                Manifest manifest = SignApk.addDigestsToManifest(this.inputJar, hash);
                SignApk.copyFiles(manifest, this.inputJar, outputJar, timestamp, 0);
                SignApk.addOtacert(outputJar, this.publicKeyFile, timestamp, manifest, hash);
                SignApk.signFile(manifest, this.inputJar, new X509Certificate[]{this.publicKey}, new PrivateKey[]{this.privateKey}, outputJar);
                this.signer.notifyClosing();
                outputJar.close();
                this.signer.finish();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public void writeSignatureBlock(ByteArrayOutputStream temp) throws IOException, CertificateEncodingException, OperatorCreationException, CMSException {
            SignApk.writeSignatureBlock(this, this.publicKey, this.privateKey, temp);
        }

        public WholeFileSignerOutputStream getSigner() {
            return this.signer;
        }
    }

    private static class WholeFileSignerOutputStream
    extends FilterOutputStream {
        private boolean closing = false;
        private ByteArrayOutputStream footer = new ByteArrayOutputStream();
        private OutputStream tee;

        public WholeFileSignerOutputStream(OutputStream out, OutputStream tee) {
            super(out);
            this.tee = tee;
        }

        public void notifyClosing() {
            this.closing = true;
        }

        public void finish() throws IOException {
            this.closing = false;
            byte[] data = this.footer.toByteArray();
            if (data.length < 2) {
                throw new IOException("Less than two bytes written to footer");
            }
            this.write(data, 0, data.length - 2);
        }

        public byte[] getTail() {
            return this.footer.toByteArray();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.closing) {
                this.footer.write(b, off, len);
            } else {
                this.out.write(b, off, len);
                this.tee.write(b, off, len);
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this.closing) {
                this.footer.write(b);
            } else {
                this.out.write(b);
                this.tee.write(b);
            }
        }
    }

    private static class CountOutputStream
    extends FilterOutputStream {
        private int mCount = 0;

        public CountOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            ++this.mCount;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.mCount += len;
        }

        public int size() {
            return this.mCount;
        }
    }
}

