package com.ihaoin.hooloo.device;

import android.app.Application;
import android.graphics.Typeface;

import com.ihaoin.hooloo.device.config.AppConfig;
import com.ihaoin.hooloo.device.data.MainData;
import com.ihaoin.hooloo.device.data.TrolleyGoods;
import com.ihaoin.hooloo.device.data.enums.PresentState;
import com.ihaoin.hooloo.device.data.vo.Category;
import com.ihaoin.hooloo.device.network.HttpUtil;
import com.ihaoin.hooloo.device.util.CollectionUtils;
import com.umeng.commonsdk.UMConfigure;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import cn.jpush.android.api.JPushInterface;

public class HLApplication extends Application {
    public static HLApplication SELF = null;

    @Override
    public void onCreate() {
        super.onCreate();
        HLApplication.SELF = this;
        setEnvConfig();
        setDefaultTypeface();

        UMConfigure.preInit(this, AppConfig.UMENG_APPKEY, AppConfig.UMENG_CHANNEL);
        UMConfigure.init(this, AppConfig.UMENG_APPKEY, AppConfig.UMENG_CHANNEL, 0, null);

        JPushInterface.setDebugMode(true);
        JPushInterface.init(this);

        AppConfig.REGISTRATION_ID = JPushInterface.getRegistrationID(this);
        HttpUtil.postRegistrationId();
    }

    private void setDefaultTypeface() {
        try {
            Typeface typefaceMonospace = Typeface.createFromAsset(getAssets(), "fonts/pingfang_jianti_regular.ttf");
            Field monospace = Typeface.class.getDeclaredField("MONOSPACE");
            monospace.setAccessible(true);
            monospace.set(null, typefaceMonospace);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setEnvConfig() {
        if (AppConfig.DEBUG) {
            // 开发测试环境
            AppConfig.HOST = AppConfig.HOST_TEST;
            AppConfig.WX_URL = AppConfig.WX_URL_TEST;
        } else {
            // 线上环境
            AppConfig.HOST = AppConfig.HOST_PROD;
            AppConfig.WX_URL = AppConfig.WX_URL_PROD;
        }

        // 第一个点单屏默认显示交互屏
        if (AppConfig.DEFAULT_SCREEN_NO.equals("1")) {
            AppConfig.DEFAULT_PRESENT = PresentState.INTERACTION.getName();
        } else {
            AppConfig.DEFAULT_PRESENT = PresentState.MENU.getName();
        }

//        if (AppConfig.DEBUG) { // TODO delete
//            return "SN0091290001";
//        }
    }

    private static MainData mainData = new MainData();
    private static List<TrolleyGoods> TROLLEY_GOODS = new ArrayList<>();

    public static MainData getMainData() {
        return mainData;
    }

    public static void setMainData(MainData data) {
        mainData = clearEmptyCategory(data);
    }

    private static MainData clearEmptyCategory(MainData data) {
        if (data != null && !CollectionUtils.isEmpty(data.getCategorys())) {
            for (int i = data.getCategorys().size() - 1; i >= 0; i--) {
                Category category = data.getCategorys().get(i);
                if (CollectionUtils.isEmpty(category.getGoods())) {
                    data.getCategorys().remove(i);
                }
            }
        }
        return data;
    }

    public static List<TrolleyGoods> getTrolleyGoods() {
        return TROLLEY_GOODS;
    }

    public static Integer getCountOfOrder() {
        if (HLApplication.getMainData() == null || HLApplication.getMainData().getCountOfOrder() == null) {
            return 9;
        }
        return HLApplication.getMainData().getCountOfOrder();
    }

    public static Integer getGoodsCount() {
        return HLApplication.getTrolleyGoods().stream().mapToInt(TrolleyGoods::getCount).sum();
    }

    public static Integer getGoodsCheckedCount() {
        return HLApplication.getTrolleyGoods().stream().filter(TrolleyGoods::getChecked).mapToInt(TrolleyGoods::getCount).sum();
    }

    public static BigDecimal getGoodsTotal() {
        return HLApplication.getTrolleyGoods().stream().map(x -> x.getSku().getDiscount().multiply(new BigDecimal(x.getCount()))).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static BigDecimal getGoodsCheckedTotal() {
        return HLApplication.getTrolleyGoods().stream().filter(TrolleyGoods::getChecked).map(x -> x.getSku().getDiscount().multiply(new BigDecimal(x.getCount()))).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}
