package com.ihaoin.hooloo.device.adapter;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseSectionQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ihaoin.hooloo.device.R;
import com.ihaoin.hooloo.device.config.Base;
import com.ihaoin.hooloo.device.data.ScrollBean;
import com.ihaoin.hooloo.device.data.enums.SkuState;
import com.ihaoin.hooloo.device.data.vo.Goods;
import com.ihaoin.hooloo.device.data.vo.Sku;
import com.ihaoin.hooloo.device.util.CollectionUtils;
import com.ihaoin.hooloo.device.util.StringUtils;
import com.ihaoin.hooloo.device.util.Utils;

import java.util.Arrays;

public class GoodsAdapter extends BaseSectionQuickAdapter<ScrollBean, BaseViewHolder> {
    private Context mContext;

    public GoodsAdapter(Context context, int layoutResId, int sectionHeadResId) {
        super(layoutResId, sectionHeadResId, null);
        this.mContext = context;
    }

    @Override
    protected void convertHead(BaseViewHolder helper, ScrollBean item) {
        helper.setText(R.id.txt_category, item.header);
    }

    @Override
    protected void convert(BaseViewHolder helper, ScrollBean item) {
        ScrollBean.ScrollItemBean t = item.t;
        ViewGroup layoutItem = helper.getView(R.id.layout_item);

        Goods goods = (Goods) t.getObject();
        helper.setText(R.id.txt_name, goods.getName());
        if (StringUtils.isEmpty(goods.getDesc())) {
            helper.setVisible(R.id.txt_intro, false);
        } else {
            helper.setVisible(R.id.txt_intro, true);
            helper.setText(R.id.txt_intro, goods.getDesc());
        }

        LinearLayout layoutTag = helper.getView(R.id.layout_tags);
        layoutTag.removeAllViews();

        if (CollectionUtils.isEmpty(goods.getTags())) {
            helper.setVisible(R.id.layout_tags, false);
            View tagView = LayoutInflater.from(mContext).inflate(R.layout.item_tag, null);
            layoutTag.addView(tagView);
        } else {
            helper.setVisible(R.id.layout_tags, true);
            goods.getTags().forEach(x -> {
                View tagView = LayoutInflater.from(mContext).inflate(R.layout.item_tag, null);
                ((TextView) tagView.findViewById(R.id.txt_tag)).setText(x);
                layoutTag.addView(tagView);
            });
        }

        ImageView imgThumbnail = helper.getView(R.id.img_thumbnail);
//        RoundedCorners roundedCorners = new RoundedCorners(5);
//        RequestOptions options = RequestOptions.bitmapTransform(roundedCorners);
        if (goods.getPics() == null) {
            imgThumbnail.setImageDrawable(null);
        } else {
//            Utils.getGlide(mContext).load(Utils.getThumbnailUrl(goods.getPics().getThumbnail())).apply(options).into(imgThumbnail);
            Utils.getGlide(mContext).load(Utils.getThumbnailUrl(goods.getPics().getThumbnail())).into(imgThumbnail);
        }

        Sku sku = Utils.getDefaultSku(goods.getSkus());
//        if (sku == null) {
//            if (goods.getPrice().compareTo(goods.getDiscount()) == 0) {
//                helper.setGone(R.id.ico_price, false);
//                helper.setGone(R.id.txt_price, false);
//            } else {
//                helper.setGone(R.id.ico_price, true);
//                helper.setGone(R.id.txt_price, true);
//            }
//            helper.setText(R.id.txt_discount, Utils.toString(goods.getDiscount()));
//            helper.setText(R.id.txt_price, Utils.toString(goods.getPrice()));
//
//            helper.setGone(R.id.txt_sellout, true);
//            helper.setGone(R.id.butn_add, false);
//        } else {
        if (sku.getPrice().compareTo(sku.getDiscount()) == 0) {
            helper.setGone(R.id.ico_price, false);
            helper.setGone(R.id.txt_price, false);
        } else {
            helper.setGone(R.id.ico_price, true);
            helper.setGone(R.id.txt_price, true);
        }
        helper.setText(R.id.txt_discount, Utils.toString(sku.getDiscount()));
        helper.setText(R.id.txt_price, Utils.toString(sku.getPrice()));

        if (SkuState.isSellin(sku.getState())) {
            helper.setGone(R.id.txt_sellout, false);
            helper.setGone(R.id.butn_add, true);
            View butnAdd = helper.getView(R.id.butn_add);
            butnAdd.setOnClickListener(v -> {
                if (!Base.TRUE.equals(sku.getIsDefault())) {
                    Utils.showToast(mContext, R.string.default_sku_sellout);
                }
                Utils.sendAddGoodsBroadcast(mContext, goods, sku, 1);
            });

            Utils.setTouchDelegate(layoutItem, Arrays.asList(butnAdd));
            layoutItem.setOnClickListener(v -> Utils.showGoodsDetail(mContext, goods));
        } else {
            helper.setGone(R.id.txt_sellout, true);
            helper.setGone(R.id.butn_add, false);
            layoutItem.setOnClickListener(v -> Utils.showToast(mContext, R.string.all_sku_sellout));
        }
//        }

        if (Base.TRUE.equals(goods.getIsRecommend())) {
            helper.setVisible(R.id.img_recommend, true);
        } else {
            helper.setGone(R.id.img_recommend, false);
        }

        TextView icoDiscount = helper.getView(R.id.ico_discount);
        TextView txtDiscount = helper.getView(R.id.txt_discount);
        TextView icoPrice = helper.getView(R.id.ico_price);
        TextView txtPrice = helper.getView(R.id.txt_price);
        icoPrice.setPaintFlags(icoPrice.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
        txtPrice.setPaintFlags(txtPrice.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);

//        layoutItem.setPadding(padding, padding, padding, padding);

        int verPadding = Utils.getDimens(mContext, R.dimen.goods_padding_ver);
        // 最后一个商品 并且购物条已经显示
        if (getData().indexOf(item) == getItemCount() - 1) {
//            int padding = Utils.getDimens(mContext, R.dimen.padding10);
            int bottomPadding = Utils.getDimens(mContext, R.dimen.goods_last_padding_bottom);
            layoutItem.setPadding(0, verPadding, 0, bottomPadding);
        } else {
            layoutItem.setPadding(0, verPadding, 0, verPadding);
        }

        Typeface tfAmount = Utils.getAmountFont(mContext);
        icoDiscount.setTypeface(tfAmount);
        txtDiscount.setTypeface(tfAmount);
        icoPrice.setTypeface(tfAmount);
        txtPrice.setTypeface(tfAmount);

        icoDiscount.getPaint().setFakeBoldText(true);
        txtDiscount.getPaint().setFakeBoldText(true);
    }

    private boolean trolleyState = false;

    public boolean isTrolleyState() {
        return trolleyState;
    }

    public void setTrolleyState(boolean trolleyState) {
        this.trolleyState = trolleyState;
    }
}
