package com.ihaoin.hooloo.device.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.ihaoin.hooloo.device.R;
import com.ihaoin.hooloo.device.data.vo.Order;
import com.ihaoin.hooloo.device.util.CollectionUtils;

import java.util.List;

public class OrderAdapter extends BaseAdapter {
    private Context mContext;
    private List<Order> orders;

    public OrderAdapter(Context context) {
        this.mContext = context;
    }

    public List<Order> getOrders() {
        return orders;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        Order order = (Order) this.getItem(position);
        TextView textView = (TextView) LayoutInflater.from(mContext).inflate(R.layout.item_number, null);
        textView.setText(order.getOrderNumber());
        textView.setTag(order);
        convertView = textView;
        return convertView;
    }

    @Override
    public boolean isEmpty() {
        return CollectionUtils.isEmpty(getOrders());
    }

    @Override
    public int getCount() {
        return isEmpty() ? 0 : getOrders().size();
    }

    @Override
    public Object getItem(int position) {
        return isEmpty() ? null : getOrders().get(position);
    }

    @Override
    public long getItemId(int position) {
        return isEmpty() ? 0 : getOrders().get(position).getOrderId();
    }
}
