package com.ihaoin.hooloo.device.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ihaoin.hooloo.device.R;
import com.ihaoin.hooloo.device.data.ScrollBean;
import com.ihaoin.hooloo.device.data.enums.SkuState;
import com.ihaoin.hooloo.device.data.vo.Recommend;
import com.ihaoin.hooloo.device.data.vo.Sku;
import com.ihaoin.hooloo.device.util.Utils;

public class RecommendAdapter extends BaseQuickAdapter<ScrollBean, BaseViewHolder> {
    private Context mContext;

    public RecommendAdapter(Context context, int layoutResId) {
        super(layoutResId, null);
        this.mContext = context;
    }

    @Override
    protected void convert(BaseViewHolder helper, ScrollBean item) {
        ScrollBean.ScrollItemBean t = item.t;
        Recommend recommend = (Recommend) t.getObject();
        TextView txtName = helper.getView(R.id.txt_name);
        TextView txtDesc = helper.getView(R.id.txt_intro);
        txtName.setText(recommend.getTitle());
        txtDesc.setText(recommend.getDesc());
        ImageView imgRecommend = helper.getView(R.id.img_recommend);

//        RoundedCorners roundedCorners = new RoundedCorners(5);
//        RequestOptions options = RequestOptions.bitmapTransform(roundedCorners);
        Utils.getGlide(mContext).load(recommend.getPic()).into(imgRecommend);

        View layoutItem = helper.getView(R.id.layout_item);
        layoutItem.setOnClickListener(v -> {

            Sku sku = Utils.getDefaultSku(recommend.getGoods().getSkus());
            if (SkuState.isSellin(sku.getState())) {
                Utils.showGoodsDetail(mContext, recommend.getGoods());
            } else {
                Utils.showToast(mContext, R.string.all_sku_sellout);
            }
        });
        helper.getConvertView().setTag(recommend);

        ViewGroup.LayoutParams lp = imgRecommend.getLayoutParams();
        if (recommend.getIndex() == 0) {
            lp.height = Utils.getDimens(mContext, R.dimen.recommend_image_height_0);
            txtName.setTextSize(Utils.getDimens(mContext, R.dimen.ts_recommend_name));
            txtDesc.setTextSize(Utils.getDimens(mContext, R.dimen.ts_recommend_desc));
        } else {
            lp.height = Utils.getDimens(mContext, R.dimen.recommend_image_height_other);
            txtName.setTextSize(Utils.getDimens(mContext, R.dimen.ts_recommend_name_small));
            txtDesc.setTextSize(Utils.getDimens(mContext, R.dimen.ts_recommend_desc_small));
        }
        imgRecommend.setLayoutParams(lp);
    }

}
