package com.ihaoin.hooloo.device.adapter;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.ToggleButton;

import com.ihaoin.hooloo.device.HLApplication;
import com.ihaoin.hooloo.device.R;
import com.ihaoin.hooloo.device.data.TrolleyGoods;
import com.ihaoin.hooloo.device.data.vo.Goods;
import com.ihaoin.hooloo.device.data.vo.Sku;
import com.ihaoin.hooloo.device.util.CollectionUtils;
import com.ihaoin.hooloo.device.util.StringAppend;
import com.ihaoin.hooloo.device.util.Utils;
import com.ihaoin.hooloo.device.view.TrolleyView;

import java.util.Arrays;
import java.util.List;

public class TrolleyAdapter extends BaseAdapter {
    private Context mContext;
    private TrolleyView trolleyView;

    public TrolleyAdapter(Context context, TrolleyView trolleyView) {
        this.mContext = context;
        this.trolleyView = trolleyView;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        TrolleyGoods trolleyGoods = (TrolleyGoods) this.getItem(position);
        Goods goods = trolleyGoods.getGoods();
        Sku sku = trolleyGoods.getSku();

        convertView = LayoutInflater.from(mContext).inflate(R.layout.item_trolley, null);
        ToggleButton butnState = convertView.findViewById(R.id.butn_state);
        ImageView imgThumbnail = convertView.findViewById(R.id.img_thumbnail);
        TextView txtName = convertView.findViewById(R.id.txt_name);
        TextView txtOptions = convertView.findViewById(R.id.txt_options);
        TextView icoPrice = convertView.findViewById(R.id.ico_price);
        TextView txtPrice = convertView.findViewById(R.id.txt_price);
        TextView icoDiscount = convertView.findViewById(R.id.ico_discount);
        TextView txtDiscount = convertView.findViewById(R.id.txt_discount);
        View butnSubtract = convertView.findViewById(R.id.butn_subtract);
        TextView txtCount = convertView.findViewById(R.id.txt_count);
        View butnAdd = convertView.findViewById(R.id.butn_add);

        butnState.setChecked(trolleyGoods.getChecked());
        butnState.setOnCheckedChangeListener((buttonView, isChecked) -> {
            trolleyGoods.setChecked(isChecked);
            if (isChecked) {
                if (!trolleyView.checkGoodsCount()) { // 购物车选中数量超过阈值，不允许选中
                    trolleyGoods.setChecked(false);
                    butnState.setChecked(false);
                    return;
                }
            }
            trolleyView.goodsChanged();
        });
        txtName.setText(goods.getName());
        if (!CollectionUtils.isEmpty(sku.getRules())) {
            StringAppend stringAppend = new StringAppend("/");
            sku.getRules().forEach(x -> stringAppend.append(x.getRuleName()));
            txtOptions.setText(stringAppend.toString());
            txtOptions.setVisibility(View.VISIBLE);
        } else {
            txtOptions.setVisibility(View.GONE);
        }

        if (sku.getPrice().compareTo(sku.getDiscount()) == 0) {
            icoPrice.setVisibility(View.GONE);
            txtPrice.setVisibility(View.GONE);
        } else {
            icoPrice.setVisibility(View.VISIBLE);
            txtPrice.setVisibility(View.VISIBLE);
        }

        txtPrice.setText(Utils.toString(sku.getPrice()));
        txtDiscount.setText(Utils.toString(sku.getDiscount()));

        icoPrice.setPaintFlags(icoPrice.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
        txtPrice.setPaintFlags(txtPrice.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
        txtCount.setText(trolleyGoods.getCount().toString());
        butnSubtract.setOnClickListener(v -> trolleyView.subtractGoods(position));
        butnAdd.setOnClickListener(v -> trolleyView.addGoods(position));
        Utils.getGlide(mContext).load(Utils.getThumbnailUrl(goods.getPics().getThumbnail())).into(imgThumbnail);

        ViewGroup layoutItem = convertView.findViewById(R.id.layout_item);
        Utils.setTouchDelegate(layoutItem, Arrays.asList(butnAdd, butnSubtract));

        Typeface tfAmount = Utils.getAmountFont(mContext);
        icoDiscount.setTypeface(tfAmount);
        txtDiscount.setTypeface(tfAmount);
        icoPrice.setTypeface(tfAmount);
        txtPrice.setTypeface(tfAmount);

        icoDiscount.getPaint().setFakeBoldText(true);
        txtDiscount.getPaint().setFakeBoldText(true);

        Typeface tfHalf = Utils.getHalfFont(mContext);
        txtCount.setTypeface(tfHalf);
        txtCount.getPaint().setFakeBoldText(true);

        return convertView;
    }

    private List<TrolleyGoods> getTrolleyGoods() {
        return HLApplication.getTrolleyGoods();
    }

    @Override
    public boolean isEmpty() {
        return getTrolleyGoods() == null || getTrolleyGoods().isEmpty() ? true : false;
    }

    @Override
    public int getCount() {
        return isEmpty() ? 0 : getTrolleyGoods().size();
    }

    @Override
    public Object getItem(int position) {
        return isEmpty() ? null : getTrolleyGoods().get(position);
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }
}
