package com.ihaoin.hooloo.device.component;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class AutoWrapLayout extends FrameLayout {
    private int paddingRight = 0;
    private int paddingTop = 0;
    private int paddingLeft = 0;
    private int paddingBottom = 0;

    public AutoWrapLayout(@NonNull Context context) {
        super(context);
    }

    public AutoWrapLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);

        int childleft = 0;
        int childtop = paddingTop;
        for (int i = 0; i < getChildCount(); i++) {
            View view = getChildAt(i);
            LayoutParams layoutParams = (LayoutParams) view.getLayoutParams();
            int viewWidth = view.getMeasuredWidth() + layoutParams.leftMargin + layoutParams.rightMargin;
            int viewHeight = view.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            if (childleft + viewWidth > right - paddingRight) {
                //换行
                childtop += viewHeight;
                childleft = 0;
            }
            if (childleft == 0) childleft += paddingLeft;
            view.layout(childleft, childtop, childleft + viewWidth, childtop + viewHeight);
            childleft += viewWidth;
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);

        int width = MeasureSpec.getSize(widthMeasureSpec);
        int right = 0;
        int height = paddingTop + paddingBottom;
        int lineMaxHeight = 0;
        for (int i = 0; i < getChildCount(); i++) {
            View view = getChildAt(i);
            LayoutParams layoutParams = (LayoutParams) view.getLayoutParams();
            int viewWidth = view.getMeasuredWidth() + layoutParams.leftMargin + layoutParams.rightMargin;
            int viewHeight = view.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            if (right + viewWidth > width) {
                //换行
                height += lineMaxHeight;
                right = 0;
                lineMaxHeight = 0;
            }
            if (right == 0) right = paddingLeft + paddingRight;
            right += viewWidth;
            if (lineMaxHeight < viewHeight) lineMaxHeight = viewHeight;
            if (i == getChildCount() - 1) height += lineMaxHeight;
        }
        setMeasuredDimension(width, height);
    }
}