package com.ihaoin.hooloo.device.component;

import android.content.Context;

import com.ihaoin.hooloo.device.data.vo.KDSMsg;
import com.ihaoin.hooloo.device.util.CollectionUtils;
import com.ihaoin.hooloo.device.util.JsonUtils;
import com.ihaoin.hooloo.device.util.StringUtils;
import com.ihaoin.hooloo.device.util.Utils;

import io.socket.client.Ack;
import io.socket.client.IO;
import io.socket.client.Socket;

/** Linux通信 KDS 菜单屏 */
public class KDSSocket extends Thread {
    private Context mContext;
    private Socket mSocket;
    private static final String mUrl = "localhost:8000";
    private static final String mNamespace = "kds";
    private String tag = "[HL_CLIENT]";

    public KDSSocket(Context context) {
        this.mContext = context;
    }

    @Override
    public void run() {
        connectSocket();
    }

    private void connectSocket() {
        try {
//            IO.Options opts = new IO.Options();
//            opts.query = "notice";
            mSocket = IO.socket(mUrl + "/" + mNamespace);
            mSocket.on("reply", args -> {
                if (CollectionUtils.isEmpty(args)) {
                    Utils.i("reply args empty");
                    return;
                }
                String content = args[0].toString();
                if (StringUtils.isEmpty(content)) {
                    Utils.i("reply content empty");
                    return;
                }
                KDSMsg msg = JsonUtils.readValue(content, KDSMsg.class);
                if (msg == null) {
                    Utils.i("reply msg empty");
                    return;
                }
                Utils.sendKdsMsgBroadcast(mContext, msg);
            });
        } catch (Exception e) {
            Utils.i("连接server失败，错误原因：" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            if (mSocket != null) {
                mSocket.disconnect();
                mSocket.close();
                mSocket = null;
            }
        } catch (Exception e) {
            Utils.i("close失败，错误原因：" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void sendMessage(String content) {
        if (mSocket == null) {
            Utils.i("socket未连接");
            return;
        }
        try {
            mSocket.emit("notice", content, (Ack) args -> {

            });
        } catch (Exception e) {
            Utils.i("发送消息失败，错误原因：" + e.getMessage());
            e.printStackTrace();
        }
    }
}
