package com.ihaoin.hooloo.device.component;

import android.os.Handler;
import android.os.Message;

import androidx.annotation.NonNull;

import com.ihaoin.hooloo.device.config.AppConfig;
import com.ihaoin.hooloo.device.util.Utils;

/**
 * 所有网络请求处理父类
 */
public abstract class NetworkHandler extends Handler {

    @Override
    public void handleMessage(@NonNull Message msg) {
        super.handleMessage(msg);
        if (AppConfig.DEBUG) {
            String url = msg.getData().getString("url");
            String msgText = String.format("请求:%s, 返回状态:%s, 返回内容:%s", url, msg.what, msg.obj);
            Utils.i(AppConfig.TAG_NETWORK, msgText);
        }
        if (msg == null || msg.what == 0) {
            return;
        }
    }
}
