package com.ihaoin.hooloo.device.component;

import android.content.Context;
import android.content.Intent;

import com.fasterxml.jackson.databind.JsonNode;
import com.ihaoin.hooloo.device.HLApplication;
import com.ihaoin.hooloo.device.config.AppConfig;
import com.ihaoin.hooloo.device.network.HttpUtil;
import com.ihaoin.hooloo.device.util.JsonUtils;
import com.ihaoin.hooloo.device.util.StringUtils;
import com.ihaoin.hooloo.device.util.Utils;

import java.io.IOException;

import cn.jpush.android.api.CmdMessage;
import cn.jpush.android.api.CustomMessage;
import cn.jpush.android.api.JPushInterface;
import cn.jpush.android.api.JPushMessage;
import cn.jpush.android.api.NotificationMessage;
import cn.jpush.android.service.JPushMessageReceiver;

public class PushMessageReceiver extends JPushMessageReceiver {
    @Override
    public void onMessage(Context context, CustomMessage customMessage) {
        Utils.i(AppConfig.TAG_PUSH, "[onMessage] " + customMessage);
        this.showToast("onMessage");
        try {
            dispatchMsg(customMessage);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void dispatchMsg(CustomMessage customMessage) throws IOException {
        JsonNode jsonNode = JsonUtils.getMapper().readValue(customMessage.message, JsonNode.class);
        String action = jsonNode.get("action").asText();
        if (StringUtils.isEmpty(action)) {
            Utils.i(AppConfig.TAG_PUSH, "msg action is empty");
            return;
        }

        Utils.fastPushBroadcast(HLApplication.SELF, action, jsonNode.get("data") == null ? null : jsonNode.get("data").toString());
    }

    @Override
    public void onNotifyMessageOpened(Context context, NotificationMessage message) {
        Utils.i(AppConfig.TAG_PUSH, "[onNotifyMessageOpened] " + message);
        this.showToast("onNotifyMessageOpened");
    }

    @Override
    public void onMultiActionClicked(Context context, Intent intent) {
        Utils.i(AppConfig.TAG_PUSH, "[onMultiActionClicked] 用户点击了通知栏按钮");
        this.showToast("onMultiActionClicked");
        String nActionExtra = intent.getExtras().getString(JPushInterface.EXTRA_NOTIFICATION_ACTION_EXTRA);

        //开发者根据不同 Action 携带的 extra 字段来分配不同的动作。
        if (nActionExtra == null) {
            Utils.i(AppConfig.TAG_PUSH, "ACTION_NOTIFICATION_CLICK_ACTION nActionExtra is null");
            return;
        }
        if (nActionExtra.equals("my_extra1")) {
            Utils.i(AppConfig.TAG_PUSH, "[onMultiActionClicked] 用户点击通知栏按钮一");
        } else if (nActionExtra.equals("my_extra2")) {
            Utils.i(AppConfig.TAG_PUSH, "[onMultiActionClicked] 用户点击通知栏按钮二");
        } else if (nActionExtra.equals("my_extra3")) {
            Utils.i(AppConfig.TAG_PUSH, "[onMultiActionClicked] 用户点击通知栏按钮三");
        } else {
            Utils.i(AppConfig.TAG_PUSH, "[onMultiActionClicked] 用户点击通知栏按钮未定义");
        }
    }

    @Override
    public void onNotifyMessageArrived(Context context, NotificationMessage message) {
        Utils.i(AppConfig.TAG_PUSH, "[onNotifyMessageArrived] " + message);
        this.showToast("onNotifyMessageArrived");
    }

    @Override
    public void onNotifyMessageDismiss(Context context, NotificationMessage message) {
        Utils.i(AppConfig.TAG_PUSH, "[onNotifyMessageDismiss] " + message);
        this.showToast("onNotifyMessageDismiss");
    }

    @Override
    public void onRegister(Context context, String registrationId) {
        Utils.i(AppConfig.TAG_PUSH, "[onRegister] " + registrationId);
        AppConfig.REGISTRATION_ID = registrationId;
        HttpUtil.postRegistrationId();
        this.showToast("onRegister");
    }

    @Override
    public void onConnected(Context context, boolean isConnected) {
        Utils.i(AppConfig.TAG_PUSH, "[onConnected] " + isConnected);
        this.showToast("onConnected");
    }

    @Override
    public void onCommandResult(Context context, CmdMessage cmdMessage) {
        Utils.i(AppConfig.TAG_PUSH, "[onCommandResult] " + cmdMessage);
        this.showToast("onCommandResult");
    }

    @Override
    public void onNotificationSettingsCheck(Context context, boolean isOn, int source) {
        super.onNotificationSettingsCheck(context, isOn, source);
        Utils.i(AppConfig.TAG_PUSH, "[onNotificationSettingsCheck] isOn:" + isOn + ",source:" + source);
        this.showToast("onNotificationSettingsCheck");
    }

    private void showToast(String content) {
    }

    @Override
    public void onTagOperatorResult(Context context, JPushMessage jPushMessage) {
//        TagAliasOperatorHelper.getInstance().onTagOperatorResult(context,jPushMessage);
        super.onTagOperatorResult(context, jPushMessage);
    }

    @Override
    public void onCheckTagOperatorResult(Context context, JPushMessage jPushMessage) {
//        TagAliasOperatorHelper.getInstance().onCheckTagOperatorResult(context,jPushMessage);
        super.onCheckTagOperatorResult(context, jPushMessage);
    }

    @Override
    public void onAliasOperatorResult(Context context, JPushMessage jPushMessage) {
//        TagAliasOperatorHelper.getInstance().onAliasOperatorResult(context,jPushMessage);
        super.onAliasOperatorResult(context, jPushMessage);
    }

    @Override
    public void onMobileNumberOperatorResult(Context context, JPushMessage jPushMessage) {
//        TagAliasOperatorHelper.getInstance().onMobileNumberOperatorResult(context,jPushMessage);
        super.onMobileNumberOperatorResult(context, jPushMessage);
    }
}
