package com.ihaoin.hooloo.device.component;

import android.content.Context;
import android.view.View;

import androidx.annotation.NonNull;

import com.ihaoin.hooloo.device.util.Utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SettingsQueue extends ArrayList<Boolean> {
    private List trigger = Arrays.asList(true, false);
//    private List trigger = Arrays.asList(true, false, true, false, true, false, true);
    private Context context;
    private View oneView;
    private View zeroView;

    public SettingsQueue(@NonNull Context context, @NonNull View oneView, @NonNull View zeroView) {
        super();
        this.context = context;
        this.oneView = oneView;
        this.zeroView = zeroView;

        this.oneView.setOnClickListener(v -> add(true));
        this.zeroView.setOnClickListener(v -> add(false));
    }

    @Override
    public boolean add(Boolean o) {
        if (size() >= trigger.size()) {
            remove(0);
        }
        boolean result = super.add(o);
        if (size() >= trigger.size()) {
            ifMatch();
        }
        return result;
    }

    private void ifMatch() {
        boolean matched = true;
        for (int i = 0; i < trigger.size(); i++) {
            if (trigger.get(i) != get(i)) {
                matched = false;
                break;
            }
        }
        if (matched) {
            Utils.openAppSettings(context);
            clear();
        }
    }
}
