package com.ihaoin.hooloo.device.component;

import android.annotation.SuppressLint;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;

import androidx.annotation.NonNull;

import com.ihaoin.hooloo.device.HLApplication;
import com.ihaoin.hooloo.device.data.vo.CheckUpdateVo;
import com.ihaoin.hooloo.device.network.HttpUtil;
import com.ihaoin.hooloo.device.util.ApkUtils;
import com.ihaoin.hooloo.device.util.Utils;

import java.io.File;

@SuppressLint("HandlerLeak")
public class UpdateService extends Thread {
    @Override
    public void run() {
        checkUpdate();
//        while (true) {
//            try {
//                if (System.currentTimeMillis() / 1000 % 60 == 0) {
//                    Utils.i("check");
//                }
//                checkUpdate();
//                Thread.sleep(1000);
//            } catch (Exception e) {
//                e.printStackTrace();
//                Utils.i("check update error");
//            }
//        }
    }

    private void checkUpdate() {
        HttpUtil.checkUpdate(checkUpdateHandler);
    }

    private Handler checkUpdateHandler = new Handler() {
        @Override
        public void handleMessage(@NonNull Message msg) {
            try {
                CheckUpdateVo updateVo = new CheckUpdateVo();
                updateVo.setUrl("https://testapi.pecktoy.com/files/upload_test/app-debug.apk");
                updateVo.setVersion("1.0.1");
                updateVo.setVersionCode(3);
//                    Object obj = msg.obj;
//                    if (msg.what == 0 || obj == null) {
//                        Utils.i("check update error");
//                        return;
//                    }
//                    CheckUpdateVo updateVo = JsonUtils.readValue(obj, CheckUpdateVo.class);
//                    if (updateVo.getVersionCode() <= 0) {
//                        Utils.i("version code is 0");
//                        return;
//                    }
//                    if (StringUtils.isEmpty(updateVo.getUrl())) {
//                        Utils.i("url is null");
//                        return;
//                    }
//                    if (StringUtils.isEmpty(updateVo.getVersion())) {
//                        Utils.i("version name is null");
//                        return;
//                    }
//
//                    PackageInfo packageInfo = Utils.getPackageInfo();
//                    if (updateVo.getVersionCode() <= packageInfo.versionCode) {
//                        Utils.i(String.format("dont update, current: %s, update: %s", packageInfo.versionCode, updateVo.getVersionCode()));
//                        return;
//                    }

                startDownload(updateVo);
            } catch (Exception e) {
                e.printStackTrace();
                Utils.i("check update error");
            }
        }
    };

    private void startDownload(CheckUpdateVo updateVo) {
        String filename = "hooloo-device_" + updateVo.getVersion() + "_" + updateVo.getVersionCode() + ".apk";
        String path = Environment.getExternalStorageDirectory().getAbsolutePath() + "/hooloo";
        if (!new File(path).exists()) {
            new File(path).mkdirs();
        }
        String file = path + "/" + filename;
        Utils.i("start download file: " + file);
        HttpUtil.download(updateVo.getUrl(), file, downloadHandler);
    }

    private Handler downloadHandler = new Handler() {
        @Override
        public void dispatchMessage(@NonNull Message msg) {
            try {
                Object obj = msg.obj;
                if (msg.what == 0 || obj == null) {
                    Utils.i("download file error");
                    return;
                }

                ApkUtils.install(HLApplication.SELF, obj.toString());
            } catch (Exception e) {
                e.printStackTrace();
                Utils.i("download file error");
            }
        }
    };
}
