package com.ihaoin.hooloo.device.data.enums;

public enum ImageState {
    CLOSED("closeDown", "歇业"),
    COOKING("inProduction", "制作中"),
    COMPLETED("thereAOrder", "有待取餐"),
    NOT_COMPLETED("noOrder", "无待取餐");

    private String code;
    private String name;

    ImageState(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static ImageState get(String code) {
        for (ImageState state : ImageState.values()) {
            if (state.getCode().equals(code)) {
                return state;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
