package com.ihaoin.hooloo.device.data.enums;

public enum OrderState {
    WAITING(2, "已支付，待制作"),
    COOKING(3, "支付制作中"),
    COMPLETED(4, "制作完成未取");

    private Integer code;
    private String name;

    OrderState(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static OrderState get(Integer code) {
        for (OrderState state : OrderState.values()) {
            if (state.getCode().equals(code)) {
                return state;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
