package com.ihaoin.hooloo.device.data.enums;

import com.ihaoin.hooloo.device.util.StringUtils;

public enum PresentState {
    NONE("不显示"),
    MENU("菜单屏"),
    INTERACTION("交互屏");

    private String name;

    PresentState(String name) {
        this.name = name;
    }

    public static PresentState get(String name) {
        if (StringUtils.isEmpty(name)) {
            return NONE;
        }
        for (PresentState state : PresentState.values()) {
            if (state.getName().equals(name)) {
                return state;
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }
}
