package com.ihaoin.hooloo.device.data.enums;

public enum SkuState {
    SELLIN(1, "可售"),
    SELLOUT(2, "不可售");

    private Integer code;
    private String name;

    SkuState(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static SkuState get(Integer code) {
        for (SkuState state : SkuState.values()) {
            if (state.getCode().equals(code)) {
                return state;
            }
        }
        return null;
    }

    public static Boolean isSellin(Integer code) {
        return SELLIN.getCode().equals(code);
    }


    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
