package com.ihaoin.hooloo.device.test;

import com.ihaoin.hooloo.device.data.vo.KDSMsg;
import com.ihaoin.hooloo.device.data.vo.KDSOrder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class KDSGen {
    public static KDSMsg getKdsMsg() {
        KDSMsg msg = new KDSMsg();
        List<String> days = Arrays.asList("Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun");
        String day = days.get(getRandom(days.size()));
        msg.setCookings(getCookings(day));
        msg.setWaitings(getOrders(day, 6));
        msg.setCompleteds(getOrders(day, 9));

        msg.setInTemperature(getRandom(10, 20));
        msg.setOutTemperature(getRandom(20, 30));
        msg.setFridgeTemperature(getRandom(0, 10));
        msg.setHumidity(getRandom(40, 70));

        msg.setCoffeeCleanTime("07月26日 09:50:07");
        msg.setChangeMaterialTime("07月26日 09:50:07");
        msg.setDailyCleanTime("07月26日 09:50:07");

        return msg;
    }

    public static List<KDSOrder> getCookings(String day) {
        int size = getRandom(2);
        List<KDSOrder> list = new ArrayList<>();
        for (int i = 0; i <= size; i++) {
            KDSOrder order = new KDSOrder();
            order.setOrderNumber(getOrderNum(day));
            order.setProgress(getRandom(100));
            list.add(order);
        }
        return list;
    }

    public static List<String> getOrders(String day, int max) {
        int size = getRandom(max);
        List<String> list = new ArrayList<>();
        for (int i = 0; i <= size; i++) {
            list.add(getOrderNum(day));
        }
        return list;
    }

    public static Integer getRandom(int min, int max) {
        int r = new Random().nextInt(max);
        if (r < min) {
            r += min;
        }
        return r;
    }

    public static Integer getRandom(int max) {
        return getRandom(0, max);
    }

    public static String getOrderNum(String day) {
        Integer num = getRandom(200, 999);
        return day + num;
    }
}
