package com.ihaoin.hooloo.device.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CollectionUtils {
    public static <T> T lastItem(Collection<T> collection) {
        if (isEmpty(collection)) {
            return null;
        }
        return (T) collection.toArray()[collection.size() - 1];
    }

    public static Integer length(Collection collection) {
        if (isEmpty(collection)) {
            return 0;
        }
        return collection.size();
    }

    public static <T> List<T> subList(List<T> list, int start, int end) {
        if (isEmpty(list)) {
            return null;
        }
        if (length(list) <= end) {
            return list;
        }
        return list.subList(start, end);
    }

    public static Boolean isEmpty(Object[] collection) {
        if (collection == null || collection.length == 0) {
            return true;
        }
        return false;
    }

    public static Boolean isEmpty(Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return true;
        }
        return false;
    }

    public static Boolean isEmpty(Map map) {
        if (map == null || map.isEmpty()) {
            return true;
        }
        return false;
    }
}
