package com.ihaoin.hooloo.device.util;


import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

public class JsonUtils {

    public static ObjectMapper getMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    public static <T> T readValue(Object obj, Class<T> cls) {
        try {
            if (obj == null) {
                return null;
            }
            return JsonUtils.getMapper().readValue(obj.toString(), cls);
        } catch (Exception e) {
            return null;
        }
    }

    public static String toString(Object obj) {
        try {
            if (obj == null) {
                return null;
            }
            return JsonUtils.getMapper().writeValueAsString(obj);
        } catch (Exception e) {
            return null;
        }
    }
}
