package com.ihaoin.hooloo.device.util;

import android.content.Context;
import android.content.SharedPreferences;

import com.ihaoin.hooloo.device.config.AppConfig;

public class SharedPreferencesUtils {
    private final static String KEY_SEETINGS = "settings";
    private final static String KEY_SCREEN_NO = "SCREEN_NO";
    private final static String KEY_PRESENTATION = "KEY_PRESENTATION";
    private final static String KEY_SHOW_LOGCAT = "SHOW_LOGCAT";
    private final static String KEY_MACHINE_CODE = "MACHINE_CODE";

    public static String getScreenNo(Context context) {
        SharedPreferences sp = getSharedPreferences(context);
        return sp.getString(KEY_SCREEN_NO, AppConfig.DEFAULT_SCREEN_NO);
    }

    public static void setScreenNo(Context context, String val) {
        SharedPreferences sp = getSharedPreferences(context);
        sp.edit().putString(KEY_SCREEN_NO, val).commit();
    }

    public static String getMachineCode(Context context) {
        SharedPreferences sp = getSharedPreferences(context);
        return sp.getString(KEY_MACHINE_CODE, "");
    }

    public static void setMachineCode(Context context, String val) {
        SharedPreferences sp = getSharedPreferences(context);
        sp.edit().putString(KEY_MACHINE_CODE, val).commit();
    }

    public static String getPresentation(Context context) {
        SharedPreferences sp = getSharedPreferences(context);
        return sp.getString(KEY_PRESENTATION, AppConfig.DEFAULT_PRESENT);
    }

    public static void setPresentation(Context context, String val) {
        SharedPreferences sp = getSharedPreferences(context);
        sp.edit().putString(KEY_PRESENTATION, val).commit();
    }

    public static Boolean getShowLogcat(Context context) {
        SharedPreferences sp = getSharedPreferences(context);
        return sp.getBoolean(KEY_SHOW_LOGCAT, false);
    }

    public static void setShowLogcat(Context context, Boolean val) {
        SharedPreferences sp = getSharedPreferences(context);
        sp.edit().putBoolean(KEY_SHOW_LOGCAT, val).commit();
    }

    public static SharedPreferences getSharedPreferences(Context context) {
        return context.getSharedPreferences(KEY_SEETINGS, Context.MODE_PRIVATE);
    }
}
