package com.ihaoin.hooloo.device.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;

import androidx.coordinatorlayout.widget.ViewGroupUtils;

import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.request.RequestOptions;
import com.ihaoin.hooloo.device.HLApplication;
import com.ihaoin.hooloo.device.R;
import com.ihaoin.hooloo.device.component.TouchDelegateComposite;
import com.ihaoin.hooloo.device.config.AppConfig;
import com.ihaoin.hooloo.device.config.Base;
import com.ihaoin.hooloo.device.data.TrolleyGoods;
import com.ihaoin.hooloo.device.data.enums.SkuState;
import com.ihaoin.hooloo.device.data.vo.Goods;
import com.ihaoin.hooloo.device.data.vo.InteractionMsg;
import com.ihaoin.hooloo.device.data.vo.KDSMsg;
import com.ihaoin.hooloo.device.data.vo.Sku;
import com.ihaoin.hooloo.device.view.ClearDialog;
import com.ihaoin.hooloo.device.view.ConfirmOrderDialog;
import com.ihaoin.hooloo.device.view.GoodsDetailDialog;
import com.ihaoin.hooloo.device.view.SettingsActivity;
import com.ihaoin.hooloo.device.view.TestDialog;
import com.ihaoin.hooloo.device.view.TipsDialog;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class Utils {

    public static PackageInfo getPackageInfo() {
        PackageInfo packageInfo = null;
        try {
            packageInfo = HLApplication.SELF.getPackageManager().getPackageInfo(HLApplication.SELF.getPackageName(), 0);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return packageInfo;
    }

    public static void i(String s) {
        Utils.i(AppConfig.TAG, s);
    }

    public static void i(String t, String s) {
        Log.i(t, s);
    }

    public static long getTimestamp() {
        return new Date().getTime();
    }

    public static void fastBroadcast(Context context, String action) {
        Intent intent = new Intent();
        intent.setAction(action);
        context.sendBroadcast(intent);
    }

    public static void fastPushBroadcast(Context context, String action, String content) {
        Intent intent = new Intent();
        intent.setAction(action);
        intent.putExtra(Base.PUSH_DEFAULT_EXTRA, content);
        context.sendBroadcast(intent);
    }

    public static void sendKdsMsgBroadcast(Context context, KDSMsg msg) {
        Intent intent = new Intent();
        intent.setAction(Base.BROADCAST_ACTION_KDS_INFO);
        intent.putExtra("msg", msg);
        context.sendBroadcast(intent);
    }

    public static void sendInteractionMsgBroadcast(Context context, InteractionMsg msg) {
        Intent intent = new Intent();
        intent.setAction(Base.BROADCAST_ACTION_INTERACTION_INFO);
        intent.putExtra("msg", msg);
        context.sendBroadcast(intent);
    }

    public static void sendAddGoodsBroadcast(Context context, Goods goods, Sku sku, Integer count) {
        Intent intent = new Intent();
        intent.setAction(Base.BROADCAST_ACTION_ADD_GOODS);
        intent.putExtra("goods", goods);
        intent.putExtra("sku", sku);
        intent.putExtra("count", count);
        context.sendBroadcast(intent);
    }

    public static void showGoodsDetail(Context context, Goods goods) {
        GoodsDetailDialog dialog = new GoodsDetailDialog(context, goods);
        dialog.show();
    }

    public static void showTips(Context context) {
        TipsDialog dialog = new TipsDialog(context);
        dialog.show();
    }

    public static void showTest(Context context) {
        TestDialog dialog = new TestDialog(context);
        dialog.show();
    }

    public static void showClearDialog(Context context) {
        ClearDialog dialog = new ClearDialog(context);
        dialog.show();
    }

    public static void showConfirmOrder(Context context, List<TrolleyGoods> trolleyGoods) {
        ConfirmOrderDialog dialog = new ConfirmOrderDialog(context);
        dialog.setGoods(trolleyGoods);
        dialog.show();
    }

    public static void showConfirmOrder(Context context, Goods goods, Sku sku, Integer count) {
        ConfirmOrderDialog dialog = new ConfirmOrderDialog(context);
        dialog.setGoods(goods, sku, count);
        dialog.show();
    }

    public static void openSystemSettings(Context context) {
        Intent intent = new Intent(android.provider.Settings.ACTION_SETTINGS);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent); // 打开系统设置界面
    }

    public static void openAppSettings(Context context) {
        Intent intent = new Intent(context, SettingsActivity.class);
        context.startActivity(intent);
    }

//    /**
//     * 获得资源 dimens (dp)
//     *
//     * @param context
//     * @param id      资源id
//     * @return
//     */
//    public static float getDimens(Context context, int id) {
//        DisplayMetrics dm = context.getResources().getDisplayMetrics();
//        float px = context.getResources().getDimension(id);
//        return px / dm.density;
//    }

    /**
     * 获得资源 dimens (px)
     *
     * @param context
     * @param id      资源id
     * @return
     */
    public static int getDimens(Context context, Integer id) {
        return (int) context.getResources().getDimension(id);
    }

    public static int dpToPx(Context context, float dp) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int) ((dp * displayMetrics.density) + 0.5f);
    }

    public static int pxTodp(Context context, float pxValue) {
        float density = context.getResources().getDisplayMetrics().density;
        return (int) (pxValue / density + 0.5f);
    }

    @SuppressLint("RestrictedApi")
    public static void setTouchDelegate(ViewGroup group, List<View> views) {
        Integer px = Utils.getDimens(group.getContext(), R.dimen.padding15);
        TouchDelegateComposite composite = new TouchDelegateComposite(group);
        views.forEach(view -> view.post(() -> {
            Rect bounds = new Rect();
            ViewGroupUtils.getDescendantRect(group, view, bounds);
            bounds.top -= px;
            bounds.left -= px;
            bounds.bottom += px;
            bounds.right += px;
            composite.addDelegate(new TouchDelegate(bounds, view));
        }));
        group.setTouchDelegate(composite);
    }

    public static String toString(BigDecimal num) {
        DecimalFormat df = new DecimalFormat("0.#");
        return df.format(num);
    }

    /** 获取SKU，优选获取默认的SKU */
    public static Sku getDefaultSku(List<Sku> skus) {
        if (CollectionUtils.isEmpty(skus)) {
            return null;
        }
        Optional<Sku> optional = skus.stream().filter(x -> Base.TRUE.equals(x.getIsDefault()) && SkuState.isSellin(x.getState())).findAny();
        if (optional.isPresent()) {
            return optional.get();
        }
        optional = skus.stream().filter(x -> SkuState.isSellin(x.getState())).findAny();
        if (optional.isPresent()) {
            return optional.get();
        }
        optional = skus.stream().filter(x -> Base.TRUE.equals(x.getIsDefault())).findAny();
        if (optional.isPresent()) {
            return optional.get();
        }
        return skus.get(0);
    }

    public static void check(RadioGroup group, int position) {
        if (group == null) {
            return;
        }
        if (group.getChildCount() < position) {
            return;
        }
        View v = group.getChildAt(position);
        if (v == null) {
            return;
        }
        group.check(v.getId());
    }

    public static RequestManager getGlide(Context context) {
        RequestOptions options = new RequestOptions().placeholder(R.mipmap.placeholder);
        return Glide.with(context).setDefaultRequestOptions(options);
    }

    public static void showToast(Context context, int resId) {
        showToast(context, context.getString(resId));
    }

    public static void showToast(Context context, String text) {
        View view = LayoutInflater.from(context).inflate(R.layout.view_toast, null);
        TextView textView = view.findViewById(R.id.txt_toast);
        textView.setText(text);

        Toast toast = Toast.makeText(context, text, Toast.LENGTH_SHORT);
        toast.setGravity(Gravity.CENTER, 0, 0);
        toast.setView(view);
        toast.show();
    }

    public static String getThumbnailUrl(String url) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }
//        return url + "?x-oss-process=image/resize,m_fill,h_100,w_100";
        return url;
    }

    public static Typeface getAmountFont(Context context) {
        return Typeface.createFromAsset(context.getAssets(), "fonts/futura_regular.ttf");
    }

    public static Typeface getHalfFont(Context context) {
        return Typeface.createFromAsset(context.getAssets(), "fonts/vnarial.ttf");
    }
}


