package com.ihaoin.hooloo.device.view;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.ihaoin.hooloo.device.R;
import com.ihaoin.hooloo.device.config.Base;
import com.ihaoin.hooloo.device.util.Utils;

public class ClearDialog extends Dialog {
    private TextView txtText;
    private View butnYes;
    private View butnNo;
    private TimerHandler timerHandler;

    public ClearDialog(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dialog_clear);
        setCancelable(false);
        setCanceledOnTouchOutside(false);

        initViews();
        LauncherActivity.TIMEOUT_TOGGLE = false;

        timerHandler = new TimerHandler();
        new Thread(() -> {
            try {
                for (int i = 10; i >= 0; i--) {
                    timerHandler.sendEmptyMessage(i);
                    Thread.sleep(1000);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    private void initViews() {
        txtText = findViewById(R.id.txt_text);
        butnYes = findViewById(R.id.butn_yes);
        butnNo = findViewById(R.id.butn_no);

        butnYes.setOnClickListener(v -> confirmClear());
        butnNo.setOnClickListener(x -> dismiss());

        setOnDismissListener(dismissListener);
    }

    private void confirmClear() {
        Utils.fastBroadcast(getContext(), Base.BROADCAST_ACTION_CLEAR_GOODS);
        Utils.fastBroadcast(getContext(), Base.BROADCAST_ACTION_TIMEOUT);
        dismiss();
    }

    OnDismissListener dismissListener = new OnDismissListener() {
        @Override
        public void onDismiss(DialogInterface dialog) {
            LauncherActivity.TIMEOUT_TOGGLE = true;
            if (timerHandler != null) {
                timerHandler.removeCallbacksAndMessages(null);
                timerHandler = null;
            }
        }
    };

    class TimerHandler extends Handler {
        @Override
        public void handleMessage(@NonNull Message msg) {
            if (msg.what <= 0) {
                confirmClear();
                return;
            }
            txtText.setText(getContext().getString(R.string.clear_tips, String.valueOf(msg.what)));
        }
    }
}
