package com.ihaoin.hooloo.device.view;

import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.viewpager.widget.ViewPager;

import com.fasterxml.jackson.databind.JsonNode;
import com.ihaoin.hooloo.device.HLApplication;
import com.ihaoin.hooloo.device.R;
import com.ihaoin.hooloo.device.component.AutoWrapLayout;
import com.ihaoin.hooloo.device.component.IntroViewPager;
import com.ihaoin.hooloo.device.component.NetworkHandler;
import com.ihaoin.hooloo.device.config.AppConfig;
import com.ihaoin.hooloo.device.config.Base;
import com.ihaoin.hooloo.device.data.enums.SkuState;
import com.ihaoin.hooloo.device.data.vo.Goods;
import com.ihaoin.hooloo.device.data.vo.GoodsRule;
import com.ihaoin.hooloo.device.data.vo.Sku;
import com.ihaoin.hooloo.device.data.vo.SkuRule;
import com.ihaoin.hooloo.device.data.vo.SkuStateChangedVo;
import com.ihaoin.hooloo.device.network.HttpUtil;
import com.ihaoin.hooloo.device.util.CollectionUtils;
import com.ihaoin.hooloo.device.util.JsonUtils;
import com.ihaoin.hooloo.device.util.StringUtils;
import com.ihaoin.hooloo.device.util.Utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class GoodsDetailDialog extends Dialog {
    private Goods mGoods;
    private Sku mSku;
    private Integer mCount = 1;

    private View butnClose;
    private IntroViewPager introPager;
    private RadioGroup introIndicator;
    private TextView txtName;
    private LinearLayout layoutSpecs;
    private LinearLayout layoutImages;
    private TextView icoPrice;
    private TextView txtPrice;
    private TextView icoDiscount;
    private TextView txtDiscount;
    private Button butnSubtract;
    private TextView txtCount;
    private Button butnAdd;
    private Button butnBuy;
    private Button butnTrolley;
    private View layoutOperate;
    private View layoutButns;

    private List<View> introViews;

    public GoodsDetailDialog(@NonNull Context context, Goods goods) {
        super(context);
        this.mGoods = goods;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dialog_goods_detail);
        initViews();
        registTimeoutReceiver();
        LauncherActivity.IN_MAIN = false;
    }

    @Override
    public boolean dispatchTouchEvent(@NonNull MotionEvent ev) {
        Utils.fastBroadcast(getContext(), Base.BROADCAST_ACTION_TOUCH_EVENT);
        return super.dispatchTouchEvent(ev);
    }

    private void initViews() {
        layoutButns = findViewById(R.id.layout_butns);
        layoutOperate = findViewById(R.id.layout_operate);
        butnClose = findViewById(R.id.butn_close);
        introPager = findViewById(R.id.intro_pager);
        introIndicator = findViewById(R.id.intro_indicator);
        txtName = findViewById(R.id.txt_name);
        layoutSpecs = findViewById(R.id.layout_specs);
        layoutImages = findViewById(R.id.layout_images);
        icoPrice = findViewById(R.id.ico_price);
        txtPrice = findViewById(R.id.txt_price);
        icoDiscount = findViewById(R.id.ico_discount);
        txtDiscount = findViewById(R.id.txt_discount);
        butnSubtract = findViewById(R.id.butn_subtract);
        txtCount = findViewById(R.id.txt_count);
        butnAdd = findViewById(R.id.butn_add);
        butnBuy = findViewById(R.id.butn_buy);
        butnTrolley = findViewById(R.id.butn_trolley);

        Typeface tfAmount = Utils.getAmountFont(getContext());
        icoDiscount.setTypeface(tfAmount);
        txtDiscount.setTypeface(tfAmount);
        icoPrice.setTypeface(tfAmount);
        txtPrice.setTypeface(tfAmount);

        icoDiscount.getPaint().setFakeBoldText(true);
        txtDiscount.getPaint().setFakeBoldText(true);

        Typeface tfHalf = Utils.getHalfFont(getContext());
        txtCount.setTypeface(tfHalf);
        txtCount.getPaint().setFakeBoldText(true);

        butnClose.setOnClickListener(x -> dismiss());

        introViews = new ArrayList<>();
        if (mGoods.getPics() != null && !CollectionUtils.isEmpty(mGoods.getPics().getIntroImages())) {
            for (int i = 0; i < mGoods.getPics().getIntroImages().size(); i++) {
                String url = mGoods.getPics().getIntroImages().get(i);
                View imgIntro = getIntroImage(url);
                View btnIntro = getIntroButton(i);
                introViews.add(imgIntro);
                introIndicator.addView(btnIntro);
            }
            introPager.setIntroViews(introViews);
            Utils.check(introIndicator, 0);
//            introIndicator.check(0);
            if (introIndicator.getChildCount() > 1) {
                introIndicator.setVisibility(View.VISIBLE);
                startPagerThread();
                introPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
                    @Override
                    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

                    }

                    @Override
                    public void onPageSelected(int position) {
                        Utils.check(introIndicator, position);
                    }

                    @Override
                    public void onPageScrollStateChanged(int state) {

                    }
                });
            }
        }

        Optional<Sku> optional = mGoods.getSkus().stream().filter(x -> Base.TRUE.equals(x.getIsDefault())).findAny();
        BigDecimal price, discount;
        if (optional.isPresent()) {
            price = optional.get().getPrice();
            discount = optional.get().getDiscount();
        } else {
            price = mGoods.getPrice();
            discount = mGoods.getDiscount();
        }

        if (price.compareTo(discount) == 0) {
            findViewById(R.id.ico_price).setVisibility(View.GONE);
            findViewById(R.id.txt_price).setVisibility(View.GONE);
        } else {
            findViewById(R.id.ico_price).setVisibility(View.VISIBLE);
            findViewById(R.id.txt_price).setVisibility(View.VISIBLE);
        }

        txtPrice.setText(Utils.toString(price));
        txtDiscount.setText(Utils.toString(discount));

        txtName.setText(mGoods.getName());
        butnSubtract.setOnClickListener(v -> subtractCount());
        butnAdd.setOnClickListener(v -> addCount());

        icoPrice.setPaintFlags(icoPrice.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
        txtPrice.setPaintFlags(txtPrice.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);

        butnBuy.setOnClickListener(v -> prepareBuyNow());
        butnTrolley.setOnClickListener(v -> prepareAddTrolley());

        ViewGroup layoutItem = findViewById(R.id.layout_item);
        Utils.setTouchDelegate(layoutItem, Arrays.asList(butnAdd, butnSubtract));

        // 处理售罄的SKU和规格选项
        processSpecRules();

        buildSpecs();
        buildDetails();

//        Utils.setTouchDelegate(findViewById(R.id.layout_root), Arrays.asList(butnClose));

        setOnDismissListener(dismissListener);
    }

    OnDismissListener dismissListener = new OnDismissListener() {
        @Override
        public void onDismiss(DialogInterface dialog) {
            if (pagerHandler != null) {
                pagerHandler.removeCallbacksAndMessages(null);
                pagerHandler = null;
            }
            if (pagerThread != null) {
                pagerThread.interrupt();
                pagerThread = null;
            }
            unregistTimeoutReceiver();
            LauncherActivity.IN_MAIN = true;
        }
    };

    private void startPagerThread() {
        pagerHandler = new PagerHandler();
        pagerThread = new PagerThread();
        pagerThread.start();
    }

    private PagerThread pagerThread;
    private PagerHandler pagerHandler;

    private class PagerThread extends Thread {
        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(1000 * 2);
                    pagerHandler.sendEmptyMessage(1);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class PagerHandler extends Handler {
        @Override
        public void handleMessage(@NonNull Message msg) {
            int index = introPager.getCurrentItem();
            int count = introPager.getCount();
            if (index + 1 >= count) {
                index = 0;
            } else {
                index++;
            }
            introPager.setCurrentItem(index, true);
        }
    }

    private View getIntroButton(int id) {
        Integer width = Utils.getDimens(getContext(), R.dimen.padding5);
        Integer height = Utils.getDimens(getContext(), R.dimen.padding5);
        RadioGroup.LayoutParams layoutParams = new RadioGroup.LayoutParams(width, height);
        layoutParams.rightMargin = Utils.getDimens(getContext(), R.dimen.padding3);

        RadioButton button = new RadioButton(getContext());
        button.setLayoutParams(layoutParams);
        button.setButtonDrawable(null);
        button.setBackgroundResource(R.drawable.sel_intro_indicator);
        button.setText("");
        button.setId(id);
        return button;
    }

    private ImageView getIntroImage(String url) {
        ImageView imgIntro = new ImageView(getContext());
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        imgIntro.setLayoutParams(layoutParams);
        imgIntro.setAdjustViewBounds(true);
        Utils.getGlide(getContext()).load(url).into(imgIntro);
        return imgIntro;
    }

    class CheckGoodsHandler extends NetworkHandler {
        private Goods goods;
        private Sku sku;
        private Integer count;
        private Integer type;

        public CheckGoodsHandler(Goods goods, Sku sku, Integer count, int type) {
            super();
            this.goods = goods;
            this.sku = sku;
            this.count = count;
            this.type = type;
        }

        @Override
        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            Object obj = msg.obj;
            if (msg.what != 1 || obj == null) {
                Utils.showToast(getContext(), R.string.error_check_sku_wrong);
                return;
            }
            JsonNode rsp = JsonUtils.readValue(obj, JsonNode.class);
            Goods rspGoods = JsonUtils.readValue(rsp.get("goods").toString(), Goods.class);
            if (rspGoods == null) {
                Utils.showToast(getContext(), R.string.error_check_sku);
                showSelloutViews();
                return;
            }

//            for (int i = 0; i < rspGoods.getSkus().size(); i++) {
//                Sku s = rspGoods.getSkus().get(i);
//                if (s.getSkuId().equals(2111) || s.getSkuId().equals(2112)) {
//                    continue;
//                }
//                s.setState(2);
//            }

//            if (true) {
            if (!SkuState.SELLIN.getCode().equals(rsp.get("state").asInt())) {
                Utils.showToast(getContext(), R.string.error_check_sku);
                setGoods(rspGoods);
                return;
            }

            if (this.type == 1) {
                buyNow(goods, sku, count);
            } else {
                addTrolley(goods, sku, count);
            }
            setGoods(rspGoods);
        }
    }

    private void setGoods(Goods rspGoods) {
        this.mGoods = rspGoods;
        if (this.mGoods != null) {
            Map<Integer, List<Sku>> map = mGoods.getSkus().stream().collect(Collectors.groupingBy(Sku::getState));
            if (CollectionUtils.isEmpty(map)) {
                return;
            }
            // 售罄SKU列表
            List<Sku> sellOuts = map.get(SkuState.SELLOUT.getCode());
            // 未售罄SKU列表
            List<Sku> sellIns = map.get(SkuState.SELLIN.getCode());

            if (!CollectionUtils.isEmpty(sellOuts)) {
                List<Integer> ids = sellOuts.stream().map(Sku::getSkuId).collect(Collectors.toList());
                SkuStateChangedVo changedVo = new SkuStateChangedVo();
                changedVo.setMachineCode(AppConfig.MACHINE_CODE);
                changedVo.setGoodsId(mGoods.getGoodsId());
                changedVo.setState(SkuState.SELLOUT.getCode());
                changedVo.setSkuIds(ids);
                Utils.fastPushBroadcast(getContext(), Base.PUSH_ACTION_SKU_STATE_CHANGED, JsonUtils.toString(changedVo));
            }
            if (!CollectionUtils.isEmpty(sellIns)) {
                List<Integer> ids = sellIns.stream().map(Sku::getSkuId).collect(Collectors.toList());
                SkuStateChangedVo changedVo = new SkuStateChangedVo();
                changedVo.setMachineCode(AppConfig.MACHINE_CODE);
                changedVo.setGoodsId(mGoods.getGoodsId());
                changedVo.setState(SkuState.SELLIN.getCode());
                changedVo.setSkuIds(ids);
                Utils.fastPushBroadcast(getContext(), Base.PUSH_ACTION_SKU_STATE_CHANGED, JsonUtils.toString(changedVo));
            }
        }
        processSpecRules();
        buildSpecs();
    }

    public void prepareBuyNow() {
        if (mSku == null) {
            Utils.showToast(getContext(), R.string.not_found_goods);
            return;
        }
        CheckGoodsHandler handler = new CheckGoodsHandler(mGoods, mSku, mCount, 1);
        HttpUtil.checkSku(mSku.getSkuId(), handler);
    }

    public void prepareAddTrolley() {
        if (mSku == null) {
            Utils.showToast(getContext(), R.string.not_found_goods);
            return;
        }
        if (mCount + HLApplication.getGoodsCount() > HLApplication.getCountOfOrder()) {
            Utils.showToast(this.getContext(), getContext().getString(R.string.count_limit, HLApplication.getCountOfOrder().toString()));
            return;
        }
        CheckGoodsHandler handler = new CheckGoodsHandler(mGoods, mSku, mCount, 0);
        HttpUtil.checkSku(mSku.getSkuId(), handler);
    }

    private void buyNow(Goods goods, Sku sku, Integer count) {
        Utils.showConfirmOrder(getContext(), goods, sku, count);
        dismiss();
    }

    private void addTrolley(Goods goods, Sku sku, Integer count) {
        Utils.sendAddGoodsBroadcast(getContext(), goods, sku, count);
        dismiss();
    }

    private void addCount() {
        if (mCount + HLApplication.getGoodsCount() >= HLApplication.getCountOfOrder()) {
            Utils.showToast(this.getContext(), getContext().getString(R.string.count_limit, HLApplication.getCountOfOrder().toString()));
            return;
        }
        mCount++;
        txtCount.setText(String.valueOf(mCount));
    }

    private void subtractCount() {
        if (mCount <= 1) {
            return;
        }
        mCount--;
        txtCount.setText(String.valueOf(mCount));
    }

    private void buildSpecs() {
        layoutSpecs.removeAllViews();
        if (CollectionUtils.isEmpty(mGoods.getSpecs())) {
            return;
        }
        mGoods.getSpecs().forEach(spec -> {
            if (CollectionUtils.isEmpty(spec.getRules())) {
                return;
            }

//            GoodsRule r1 = new GoodsRule();
//            GoodsRule r2 = new GoodsRule();
//            GoodsRule r3 = new GoodsRule();
//            r1.setRuleId(101);
//            r1.setRuleName("101");
//            r1.setIsDefault(0);
//            r1.setIsRecommend(0);
//            r1.setState(1);
//            r1.setPrice(new BigDecimal("1"));
//
//            r2.setRuleId(102);
//            r2.setRuleName("102");
//            r2.setIsDefault(0);
//            r2.setIsRecommend(0);
//            r2.setState(1);
//            r2.setPrice(new BigDecimal("2"));
//
//            r3.setRuleId(103);
//            r3.setRuleName("103");
//            r3.setIsDefault(0);
//            r3.setIsRecommend(0);
//            r3.setState(1);
//            r3.setPrice(new BigDecimal("3"));
//
//            spec.getRules().add(r1);
//            spec.getRules().add(r2);
//            spec.getRules().add(r3);

            View specView = getLayoutInflater().inflate(R.layout.item_spec, null);
            TextView txtName = specView.findViewById(R.id.txt_name);
            AutoWrapLayout layoutRules = specView.findViewById(R.id.layout_rules);

            txtName.setText(spec.getSpecName());
            spec.getRules().forEach(rule -> {
                AutoWrapLayout.LayoutParams layoutParams = new AutoWrapLayout.LayoutParams(RadioGroup.LayoutParams.WRAP_CONTENT, RadioGroup.LayoutParams.WRAP_CONTENT);
                layoutParams.rightMargin = Utils.getDimens(getContext(), R.dimen.padding5);

                View ruleView = getLayoutInflater().inflate(R.layout.item_spec_rule, null);
                ruleView.setTag(rule);

                TextView button = ruleView.findViewById(R.id.butn_rule);
                button.setId(rule.getRuleId());
                button.setText(rule.getRuleName());
                if (Base.TRUE.equals(rule.getIsRecommend())) {
                    ruleView.findViewById(R.id.txt_recommend).setVisibility(View.VISIBLE);
                }
                if (!SkuState.isSellin(rule.getState())) {
                    button.setEnabled(false);
                } else {
                    if (Base.TRUE.equals(rule.getIsDefault())) {
                        button.setSelected(true);
                        ruleView.setSelected(true);
                    }
                    ruleView.setOnClickListener(v -> {
                        clearSelected(layoutRules);
                        ruleView.setSelected(true);
                        button.setSelected(true);
                        changeSkuWithRule();
                    });
                }
                layoutRules.addView(ruleView, layoutParams);
            });
            layoutSpecs.addView(specView);
//            layoutRules.setOnCheckedChangeListener((group, checkedId) -> changeSkuWithRule());
        });
        changeSkuWithRule();
    }

    private void clearSelected(ViewGroup group) {
        if (group.getChildCount() <= 0) {
            return;
        }
        for (int i = 0; i < group.getChildCount(); i++) {
            View v = group.getChildAt(i);
            v.setSelected(false);
            if (v instanceof ViewGroup) {
                clearSelected((ViewGroup) v);
            }
        }
    }

    private void changeSkuWithRule() {
        if (layoutSpecs.getChildCount() <= 0) {
            return;
        }
        List<GoodsRule> rules = new ArrayList<>();
        for (int i = 0; i < layoutSpecs.getChildCount(); i++) {
            View v = layoutSpecs.getChildAt(i);
            AutoWrapLayout layoutRules = v.findViewById(R.id.layout_rules);
            View view = getSelectedView(layoutRules);
            if (view == null) {
                continue;
            }
            rules.add((GoodsRule) view.getTag());
        }
        mSku = matchSku(rules);
        if (mSku == null) {
            return;
        }
        txtPrice.setText(Utils.toString(mSku.getPrice()));
        txtDiscount.setText(Utils.toString(mSku.getDiscount()));
    }

    private View getSelectedView(AutoWrapLayout layoutRules) {
        if (layoutRules.getChildCount() <= 0) {
            return null;
        }
        for (int i = 0; i < layoutRules.getChildCount(); i++) {
            View v = layoutRules.getChildAt(i);
            if (v.isSelected()) {
                return v;
            }
        }
        return null;
    }

    private Sku matchSku(List<GoodsRule> rules) {
        if (CollectionUtils.isEmpty(rules)) {
            return null;
        }
        if (CollectionUtils.isEmpty(mGoods.getSkus())) {
            return null;
        }
        List<Integer> checkRuleIds = rules.stream().map(GoodsRule::getRuleId).sorted().collect(Collectors.toList());
        for (Sku sku : mGoods.getSkus()) {
            List<Integer> skuRuleIds = sku.getRules().stream().map(SkuRule::getRuleId).sorted().collect(Collectors.toList());
            if (skuRuleIds.toString().equals(checkRuleIds.toString())) {
                return sku;
            }
        }
        return null;
    }

    private void buildDetails() {
        if (mGoods.getPics() == null || CollectionUtils.isEmpty(mGoods.getPics().getDetailImages())) {
            return;
        }
        mGoods.getPics().getDetailImages().forEach(url -> {
            if (StringUtils.isEmpty(url)) {
                return;
            }
            ImageView imageView = new ImageView(getContext());
            imageView.setAdjustViewBounds(true);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);
//            layoutParams.bottomMargin = Utils.getDimens(getContext(), R.dimen.padding5);
            Utils.getGlide(getContext()).load(url).into(imageView);
            layoutImages.addView(imageView, layoutParams);
        });
    }

    private void processSpecRules() {
        if (mGoods == null || CollectionUtils.isEmpty(mGoods.getSpecs()) || CollectionUtils.isEmpty(mGoods.getSkus())) {
            showSelloutViews();
            return;
        }
        mGoods.getSpecs().forEach(spec -> {
            if (CollectionUtils.isEmpty(spec.getRules())) {
                return;
            }
            spec.getRules().forEach(rule -> rule.setState(SkuState.SELLIN.getCode()));
        });
        // 将商品所有SKU列表按售罄和未售罄分组
        Map<Integer, List<Sku>> map = mGoods.getSkus().stream().collect(Collectors.groupingBy(Sku::getState));
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        // 售罄SKU列表
        List<Sku> sellOuts = map.get(SkuState.SELLOUT.getCode());
        // 未售罄SKU列表
        List<Sku> sellIns = map.get(SkuState.SELLIN.getCode());
        if (CollectionUtils.isEmpty(sellIns)) {
            showSelloutViews();
            return;
        }
        // 售罄SKU列表为空不需要处理
        if (CollectionUtils.isEmpty(sellOuts)) {
            return;
        }
        sellOuts.forEach(sku -> {
            if (CollectionUtils.isEmpty(sku.getRules())) {
                return;
            }
            sku.getRules().forEach(skuRule -> {
                // 检查未售罄的sku里是否有此规格选项，如果有则此选项可选
                Integer ruleState = checkRuleState(skuRule, sellIns);
                setRuleState(skuRule, ruleState);
            });
        });
    }

    /** 检查未售罄的sku里是否有此规格选项，如果有则此选项可选 */
    private Integer checkRuleState(SkuRule skuRule, List<Sku> sellIns) {
        if (CollectionUtils.isEmpty(sellIns)) {
            return Base.FALSE;
        }

        for (Sku sku : sellIns) {
            if (CollectionUtils.isEmpty(sku.getRules())) {
                continue;
            }
            for (SkuRule rule : sku.getRules()) {
                if (rule.getRuleId().equals(skuRule.getRuleId())) {
                    return Base.TRUE;
                }
            }
        }
        return Base.FALSE;
    }

    /** 设备商品规格 选项状态 */
    private void setRuleState(SkuRule skuRule, Integer ruleState) {
        if (mGoods == null || CollectionUtils.isEmpty(mGoods.getSpecs())) {
            return;
        }
        mGoods.getSpecs().forEach(spec -> {
            // 选项为空的规格不处理
            if (CollectionUtils.isEmpty(spec.getRules())) {
                return;
            }
            spec.getRules().forEach(rule -> {
                // 设置匹配的选项
                if (rule.getRuleId().equals(skuRule.getRuleId())) {
                    rule.setState(ruleState);
                }
            });
        });
    }

    private void showSelloutViews() {
        dismiss();
    }

    private TimeoutReceiver timeoutReceiver;

    class TimeoutReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            dismiss();
        }
    }

    private void registTimeoutReceiver() {
        timeoutReceiver = new TimeoutReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction(Base.BROADCAST_ACTION_TIMEOUT);
        this.getContext().registerReceiver(timeoutReceiver, filter);
    }

    private void unregistTimeoutReceiver() {
        if (timeoutReceiver != null) {
            this.getContext().unregisterReceiver(timeoutReceiver);
            timeoutReceiver = null;
        }
    }

}
