package com.ihaoin.hooloo.device.view;

import android.app.Presentation;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.view.Display;

import com.ihaoin.hooloo.device.R;
import com.ihaoin.hooloo.device.config.Base;
import com.ihaoin.hooloo.device.util.Utils;

public class InteractionPresentation extends Presentation {

    public InteractionPresentation(Context outerContext, Display display) {
        super(outerContext, display);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.present_interaction);

        initViews();

        setOnDismissListener(dismissListener);
        registInteractionReceiver();
    }

    private void initViews() {
    }

    OnDismissListener dismissListener = new OnDismissListener() {
        @Override
        public void onDismiss(DialogInterface dialog) {
            Utils.i("interaction present dismiss");
            unregistInteractionReceiver();
        }
    };

    InteractionReceiver interactionReceiver = null;

    private void registInteractionReceiver() {
        interactionReceiver = new InteractionReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction(Base.BROADCAST_ACTION_INTERACTION_INFO);
        getContext().registerReceiver(interactionReceiver, filter);
    }

    private void unregistInteractionReceiver() {
        if (interactionReceiver != null) {
            getContext().unregisterReceiver(interactionReceiver);
            interactionReceiver = null;
        }
    }

    class InteractionReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
        }
    }
}
