package com.ihaoin.hooloo.device.view;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.transition.Transition;
import com.ihaoin.hooloo.device.HLApplication;
import com.ihaoin.hooloo.device.R;
import com.ihaoin.hooloo.device.adapter.GoodsAdapter;
import com.ihaoin.hooloo.device.adapter.RecommendAdapter;
import com.ihaoin.hooloo.device.component.InteractionSocket;
import com.ihaoin.hooloo.device.component.KDSSocket;
import com.ihaoin.hooloo.device.component.NetworkHandler;
import com.ihaoin.hooloo.device.component.SettingsQueue;
import com.ihaoin.hooloo.device.component.UpdateService;
import com.ihaoin.hooloo.device.config.AppConfig;
import com.ihaoin.hooloo.device.config.Base;
import com.ihaoin.hooloo.device.data.MainData;
import com.ihaoin.hooloo.device.data.ScrollBean;
import com.ihaoin.hooloo.device.data.enums.PresentState;
import com.ihaoin.hooloo.device.data.enums.SkuState;
import com.ihaoin.hooloo.device.data.vo.Category;
import com.ihaoin.hooloo.device.data.vo.Goods;
import com.ihaoin.hooloo.device.data.vo.Recommend;
import com.ihaoin.hooloo.device.data.vo.Sku;
import com.ihaoin.hooloo.device.data.vo.SkuStateChangedVo;
import com.ihaoin.hooloo.device.network.HttpUtil;
import com.ihaoin.hooloo.device.util.CollectionUtils;
import com.ihaoin.hooloo.device.util.JsonUtils;
import com.ihaoin.hooloo.device.util.SharedPreferencesUtils;
import com.ihaoin.hooloo.device.util.StringUtils;
import com.ihaoin.hooloo.device.util.Utils;

import java.util.ArrayList;
import java.util.List;

public class LauncherActivity extends Activity {
    private SkuStateChangeReceiver skuChangeReceiver;
    private GoodsChangeReceiver goodsChangeReceiver;
    private TouchReceiver touchReceiver;

    private RadioGroup groupCategory;
    private RecyclerView recGoods;
    private RecyclerView recRecommends;
    private TextView txtCategory;
    private View layoutTips;

    private List<ScrollBean> scrollRecommends;
    private List<ScrollBean> scrollGoods;

    private GridLayoutManager recommendManager;
    private LinearLayoutManager goodsLayoutManager;

    private RecommendAdapter recommendAdapter;
    private GoodsAdapter goodsAdapter;
    //右侧title在数据中所对应的position集合
    private List<Integer> tPosition = new ArrayList<>();
    //记录商品当前可见的第一个item的position
    private int first = 0;
    private TrolleyView trolleyView;
    private MenuPresentation menuView;
    private InteractionPresentation presentView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_launcher);
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);

        requestPermissions();

        initViews();
        initRecommends();
        setRecommendsData();
        initCategorys();
        initGoods();
        setGoodsData();

        registTrolleyGoodsChangedReceiver();
        registTrolleyStateChangedReceiver();
        registSettingChangedReceiver();
        preparePresentView();
        registSkuChangeReceiver();
        registGoodsChangeReceiver();
        registTouchReceiver();

        initSettingsQueue();

        startTimeoutThread();
        getMachineCode();

        new UpdateService().start();
    }

    private void initViews() {
        txtCategory = findViewById(R.id.txt_category);
        trolleyView = findViewById(R.id.view_trolley);
        groupCategory = findViewById(R.id.group_category);
        recGoods = findViewById(R.id.rec_right);
        recRecommends = findViewById(R.id.rec_recommend);
        layoutTips = findViewById(R.id.layout_tips);
        layoutTips.setOnClickListener(v -> Utils.showTips(LauncherActivity.this));
    }

    private void startTimeoutThread() {
        new TimeoutThread().start();
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        Utils.i("dispatchTouchEvent");
        TIMESTAMP = Utils.getTimestamp();
        return super.dispatchTouchEvent(ev);
    }

    private void initSettingsQueue() {
        View imgLogo = findViewById(R.id.img_logo);
        new SettingsQueue(this, imgLogo, txtCategory);
    }

    private void getMachineCode() {
//        AppConfig.MACHINE_CODE = SharedPreferencesUtils.getMachineCode(this);
//        if (StringUtils.isEmpty(AppConfig.MACHINE_CODE)) {
//            Utils.fastBroadcast(this, Base.BROADCAST_SOCKET_GET_MACHINE_CODE); // 从设备上获取机器编码
//            return;
//        }
//        Utils.i("machine code: " + AppConfig.MACHINE_CODE);
//        loadData();
//        HttpUtil.postRegistrationId();
    }

    private void initRecommends() {
        recommendManager = new GridLayoutManager(this, 2);
        recommendManager.setSpanSizeLookup(new MySpanSizeLookup());
        recRecommends.addItemDecoration(new MyItemDecoration());

        if (recommendAdapter == null) {
            recommendAdapter = new RecommendAdapter(this, R.layout.item_recommend);
            recRecommends.setAdapter(recommendAdapter);
            recRecommends.setLayoutManager(recommendManager);
        } else {
            recommendAdapter.notifyDataSetChanged();
        }

    }

    private void setRecommendsData() {
        List<Recommend> recommends = HLApplication.getMainData().getRecommends();
        scrollRecommends = new ArrayList<>();
        if (!CollectionUtils.isEmpty(recommends)) {
            for (int i = 0; i < recommends.size(); i++) {
                Recommend x = recommends.get(i);
                x.setIndex(i);
                scrollRecommends.add(new ScrollBean(new ScrollBean.ScrollItemBean(x, null)));
            }
        }
        recommendAdapter.setNewData(scrollRecommends);
    }

    class MySpanSizeLookup extends GridLayoutManager.SpanSizeLookup {
        @Override
        public int getSpanSize(int position) {
            if (position == 0) {
                return 2;
            }
            return 1;
        }
    }

    class MyItemDecoration extends RecyclerView.ItemDecoration {
        @Override
        public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            Recommend recommend = (Recommend) view.getTag();

            outRect.bottom = 20;
            if (recommend.getIndex() > 0) {
                if (recommend.getIndex() % 2 == 1) {
                    outRect.right = 10;
                } else {
                    outRect.left = 10;
                }
            }
        }
    }

    private void initGoods() {
        goodsLayoutManager = new LinearLayoutManager(this);
        if (goodsAdapter == null) {
            goodsAdapter = new GoodsAdapter(this, R.layout.item_goods, R.layout.item_goods_category);
            recGoods.setAdapter(goodsAdapter);
            recGoods.setLayoutManager(goodsLayoutManager);
        } else {
            goodsAdapter.notifyDataSetChanged();
        }
        goodsAdapter.setNewData(scrollGoods);

        // 商品滚动时同时设置分类变化
        recGoods.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                // 商品滚动时获取当前显示的第一个商品的分类名称
                int firstPosition = goodsLayoutManager.findFirstVisibleItemPosition();
                String title = "";
                if (first != firstPosition && firstPosition >= 0) {
                    //给first赋值
                    first = firstPosition;


                    //判断如果右侧可见的第一个item是否是header,设置相应的值
                    if (scrollGoods.get(first).isHeader) {
                        title = scrollGoods.get(first).header;
                    } else {
                        title = scrollGoods.get(first).t.getType();
                    }
                    txtCategory.setText(title);
                }

                // 设置分类移动动画
                RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams) txtCategory.getLayoutParams();
                lp.setMargins(0, 0, 0, 0);
                int nextPosition = firstPosition + 1; // 当前显示的下一个索引
                if (nextPosition < scrollGoods.size()) { // 已经是最后一个item
                    if (scrollGoods.get(nextPosition).isHeader) { // 下一个是否是标题
                        int paddingTop = Utils.getDimens(LauncherActivity.this, R.dimen.goods_padding_top);
                        View nextView = goodsLayoutManager.findViewByPosition(nextPosition); // 下一个view
                        int[] location = new int[2];
                        nextView.getLocationInWindow(location);
                        int topMargin = location[1] - paddingTop;
                        int height = nextView.getHeight();
                        if (topMargin < height) {
                            lp.setMargins(0, -(height - topMargin), 0, 0);
                        }
                    }
                }
                txtCategory.setLayoutParams(lp);

                // 遍历分类列表，设置选中分类
                List<Category> categorys = HLApplication.getMainData().getCategorys();
                for (Category category : categorys) {
                    if (category.getName().equals(title)) {
                        if (groupCategory.getCheckedRadioButtonId() == category.getId()) {
                            break;
                        }
                        groupCategory.check(category.getId());
                    }
                }

                if (isSlideToBottom(recGoods)) {
                    // 滚动到最下，选中最后一个分类
                    groupCategory.check(CollectionUtils.lastItem(categorys).getId());
                }
            }
        });
    }

    /** 判断RecyclerView是否滚动到最下面 */
    private boolean isSlideToBottom(RecyclerView recyclerView) {
        if (recyclerView == null) {
            return false;
        }
        if (recyclerView.computeVerticalScrollExtent() + recyclerView.computeVerticalScrollOffset() >= recyclerView.computeVerticalScrollRange()) {
            return true;
        }
        return false;
    }

    private void initCategorys() {
        int w = Utils.getDimens(LauncherActivity.this, R.dimen.category_drawable_width);
        int h = Utils.getDimens(LauncherActivity.this, R.dimen.category_drawable_height);
        int drawablePadding = Utils.getDimens(LauncherActivity.this, R.dimen.category_drawable_padding);
        Rect rect = new Rect(0, 0, w, h);

        groupCategory.removeAllViews();
        List<Category> categorys = HLApplication.getMainData().getCategorys();
        if (!CollectionUtils.isEmpty(categorys)) {
            for (int i = 0; i < categorys.size(); i++) {
                Category category = categorys.get(i);
                if (CollectionUtils.isEmpty(category.getGoods())) {
                    continue;
                }
                RadioGroup.LayoutParams layoutParams = new RadioGroup.LayoutParams(RadioGroup.LayoutParams.MATCH_PARENT, RadioGroup.LayoutParams.WRAP_CONTENT);
                RadioButton butnRadio = (RadioButton) this.getLayoutInflater().inflate(R.layout.item_category, null);
                butnRadio.setText(category.getName());
                butnRadio.setId(category.getId());
                butnRadio.setTag(category);
                if (i == 0) {
                    butnRadio.setChecked(true);
                    butnRadio.getPaint().setFakeBoldText(true);
                }
                Utils.getGlide(LauncherActivity.this).load(category.getIcon()).into(new CustomTarget<Drawable>() {
                    @Override
                    public void onResourceReady(@NonNull Drawable drawable, @Nullable Transition<? super Drawable> transition) {
                        drawable.setBounds(rect);
                        butnRadio.setCompoundDrawablePadding(drawablePadding);
                        butnRadio.setCompoundDrawables(null, drawable, null, null);
                    }

                    @Override
                    public void onLoadCleared(@Nullable Drawable placeholder) {

                    }
                });
                groupCategory.addView(butnRadio, layoutParams);

                butnRadio.setOnClickListener(v -> {
                    Integer checkedId = v.getId();
                    Category tagCategory = (Category) groupCategory.findViewById(checkedId).getTag();
                    int position = categorys.indexOf(tagCategory);
                    goodsLayoutManager.scrollToPositionWithOffset(tPosition.get(position), 0);
                });
            }
        }
        groupCategory.setOnCheckedChangeListener((group, checkedId) -> {
            for (int i = 0; i < groupCategory.getChildCount(); i++) {
                View child = groupCategory.getChildAt(i);
                if (!(child instanceof RadioButton)) {
                    continue;
                }
                RadioButton butn = (RadioButton) child;
                if (butn.getId() == checkedId) {
                    butn.getPaint().setFakeBoldText(true);
                } else {
                    butn.getPaint().setFakeBoldText(false);
                }
            }
        });
    }

    private void setGoodsData() {
        List<Category> categorys = HLApplication.getMainData().getCategorys();
        if (CollectionUtils.isEmpty(categorys)) {
            return;
        }

        scrollGoods = new ArrayList<>();
        categorys.forEach(category -> {
            if (CollectionUtils.isEmpty(category.getGoods())) {
                return;
            }
            scrollGoods.add(new ScrollBean(true, category.getName()));
            category.getGoods().forEach(goods -> scrollGoods.add(new ScrollBean(new ScrollBean.ScrollItemBean(goods, category.getName()))));
        });

        for (int i = 0; i < scrollGoods.size(); i++) {
            if (scrollGoods.get(i).isHeader) {
                //遍历右侧列表,判断如果是header,则将此header在右侧列表中所在的position添加到集合中
                tPosition.add(i);
            }
        }
        goodsAdapter.setNewData(scrollGoods);

        recGoods.scrollBy(0, 0);
        if (CollectionUtils.isEmpty(scrollGoods)) {
            txtCategory.setText("");
        } else {
            txtCategory.setText(scrollGoods.get(0).header);
        }
    }

//    private void startLoadDataThread() {
//        loadData();
////        new Thread(() -> {
////            try {
////                while (true) {
////                    runOnUiThread(() -> loadData());
////                    Thread.sleep(1000 * 10);
////                }
////            } catch (Exception e) {
////                e.printStackTrace();
////            }
////        }).start();
//    }

    private LoadDataHandler loadDataHandler;

    private void loadData() {
        loadDataHandler = new LoadDataHandler();
        HttpUtil.getMainDatas(loadDataHandler);
    }

    class LoadDataHandler extends NetworkHandler {
        @Override
        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            try {
                Object obj = msg.obj;
                if (msg.what == 0 || obj == null) {
                    Utils.showToast(LauncherActivity.this, R.string.error_load_main_data);
                    return;
                }
                MainData mainData = JsonUtils.getMapper().readValue(obj.toString(), MainData.class);
                HLApplication.setMainData(mainData);
                mainDataChanged();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void mainDataChanged() {
        setRecommendsData();
        initCategorys();
        setGoodsData();
        if (menuView != null) {
            menuView.mainDataChanged();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        exit();
    }

    private void exit() {
        this.unregistTrolleyGoodsChangedReceiver();
        this.unregistTrolleyStateChangedReceiver();
        this.unregistSettingChangedReceiver();
        this.unregistSkuChangeReceiver();
        this.unregistGoodsChangeReceiver();
        this.unregistTouchReceiver();
        System.exit(0);
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        exit();
    }

    private TrolleyGoodsChangedReceiver trolleyGoodsChangedReceiver = null;
    private TrolleyStateChangedReceiver trolleyStateChangedReceiver = null;
    private SettingChangedReceiver settingChangedReceiver;

    /** 注册购物车广播 */
    private void registTrolleyGoodsChangedReceiver() {
        if (trolleyGoodsChangedReceiver == null) {
            trolleyGoodsChangedReceiver = new TrolleyGoodsChangedReceiver();
            IntentFilter filter = new IntentFilter();
            filter.addAction(Base.BROADCAST_ACTION_ADD_GOODS);
            filter.addAction(Base.BROADCAST_ACTION_GOODS_CHANGED);
            filter.addAction(Base.BROADCAST_ACTION_CLEAR_GOODS);
            this.registerReceiver(trolleyGoodsChangedReceiver, filter);
        }
    }

    private void unregistTrolleyGoodsChangedReceiver() {
        if (trolleyGoodsChangedReceiver != null) {
            this.unregisterReceiver(trolleyGoodsChangedReceiver);
            trolleyGoodsChangedReceiver = null;
        }
    }

    /** 购物车操作广播接收器 */
    class TrolleyGoodsChangedReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals(Base.BROADCAST_ACTION_ADD_GOODS)) {
                Goods goods = (Goods) intent.getSerializableExtra("goods");
                Sku sku = (Sku) intent.getSerializableExtra("sku");
                Integer count = intent.getIntExtra("count", 1);
                trolleyView.prepareAddGoods(goods, sku, count);
            } else if (intent.getAction().equals(Base.BROADCAST_ACTION_GOODS_CHANGED)) {
                trolleyView.goodsChanged();
            } else if (intent.getAction().equals(Base.BROADCAST_ACTION_CLEAR_GOODS)) {
                trolleyView.clearTrolley();
            }
        }
    }

    private void registTrolleyStateChangedReceiver() {
        trolleyStateChangedReceiver = new TrolleyStateChangedReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction(Base.BROADCAST_ACTION_TROLLEY_SHOW);
        filter.addAction(Base.BROADCAST_ACTION_TROLLEY_HIDE);
        this.registerReceiver(trolleyStateChangedReceiver, filter);
    }

    private void unregistTrolleyStateChangedReceiver() {
        if (trolleyStateChangedReceiver != null) {
            this.unregisterReceiver(trolleyStateChangedReceiver);
            trolleyStateChangedReceiver = null;
        }
    }

    class TrolleyStateChangedReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (StringUtils.isEmpty(intent.getAction())) {
                return;
            }
            if (goodsAdapter == null) {
                return;
            }
            if (intent.getAction().equals(Base.BROADCAST_ACTION_TROLLEY_SHOW)) {
                goodsAdapter.setTrolleyState(true);
            } else {
                goodsAdapter.setTrolleyState(false);
            }
            goodsAdapter.notifyDataSetChanged();
        }
    }

    private class SettingChangedReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals(Base.BROADCAST_ACTION_MACHINE_CODE_CHANGED)) {
                getMachineCode();
            } else if (intent.getAction().equals(Base.BROADCAST_ACTION_PRESENT_CHANGED)) {
                preparePresentView();
            } else if (intent.getAction().equals(Base.BROADCAST_ACTION_LOGCAT_STATE_CHANGED)) {
                if (SharedPreferencesUtils.getShowLogcat(LauncherActivity.this)) {
                    Utils.showToast(LauncherActivity.this, "展示Logcat");
                } else {
                    Utils.showToast(LauncherActivity.this, "隐藏Logcat");
                }
            }
        }
    }

    /** 显示副屏内容 */
    private void preparePresentView() {
        PresentState present = PresentState.get(SharedPreferencesUtils.getPresentation(LauncherActivity.this));
        switch (present) {
            case MENU:
                showMenuView();
                hideInteractionView();
                return;
            case INTERACTION:
                hideMenuView();
                showInteractionView();
                return;
            default:
                hideMenuView();
                hideInteractionView();
                return;
        }
    }

    /** 显示交互屏 */
    private void showInteractionView() {
        if (AppConfig.DEBUG) {
            Utils.showToast(this, "展示交互屏");
        }
        if (presentView != null) {
            return;
        }
        DisplayManager displayManager = (DisplayManager) getSystemService(Context.DISPLAY_SERVICE);
        Display[] displays = displayManager.getDisplays();
        if (CollectionUtils.isEmpty(displays) || displays.length < 2) {
            Utils.showToast(this, "未获取到菜单屏硬件");
            return;
        }
        presentView = new InteractionPresentation(this, displays[1]);
        presentView.show();

        startIAClient();
    }

    /** 隐藏交互屏 */
    private void hideInteractionView() {
        if (AppConfig.DEBUG) {
            Utils.showToast(this, "隐藏交互屏");
        }
        if (presentView == null) {
            return;
        }
        presentView.dismiss();
        presentView = null;

        stopIAClient();
    }

    /** 显示菜单屏KDS */
    private void showMenuView() {
        if (AppConfig.DEBUG) {
            Utils.showToast(this, "展示菜单屏");
        }
        if (menuView != null) {
            return;
        }
        DisplayManager displayManager = (DisplayManager) getSystemService(Context.DISPLAY_SERVICE);
        Display[] displays = displayManager.getDisplays();
        if (CollectionUtils.isEmpty(displays) || displays.length < 2) {
            Utils.showToast(this, "未获取到菜单屏硬件");
            return;
        }
        menuView = new MenuPresentation(this, displays[1]);
        menuView.show();

        startKdsClient();
    }

    private void hideMenuView() {
        if (AppConfig.DEBUG) {
            Utils.showToast(this, "隐藏菜单屏");
        }
        if (menuView == null) {
            return;
        }
        menuView.dismiss();
        menuView = null;

        stopKdsClient();
    }

    private KDSSocket kdsSocket = null;
    private InteractionSocket interactionSocket = null;

    private void startKdsClient() {
        kdsSocket = new KDSSocket(this);
        kdsSocket.start();
    }

    private void stopKdsClient() {
        if (kdsSocket != null) {
            kdsSocket.close();
            kdsSocket = null;
        }
    }

    private void startIAClient() {
        interactionSocket = new InteractionSocket(this);
        interactionSocket.start();
    }

    private void stopIAClient() {
        if (interactionSocket != null) {
            interactionSocket.close();
            interactionSocket = null;
        }
    }

    private void requestPermissions() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            requestPermissions(new String[]{Manifest.permission.READ_PHONE_STATE, Manifest.permission.READ_EXTERNAL_STORAGE, Manifest.permission.WRITE_EXTERNAL_STORAGE}, 100);
        }
    }

    private void registSettingChangedReceiver() {
        settingChangedReceiver = new SettingChangedReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction(Base.BROADCAST_ACTION_MACHINE_CODE_CHANGED);
        filter.addAction(Base.BROADCAST_ACTION_PRESENT_CHANGED);
        filter.addAction(Base.BROADCAST_ACTION_LOGCAT_STATE_CHANGED);
        this.registerReceiver(settingChangedReceiver, filter);
    }

    private void unregistSettingChangedReceiver() {
        if (settingChangedReceiver != null) {
            this.unregisterReceiver(settingChangedReceiver);
            settingChangedReceiver = null;
        }
    }

    private void registSkuChangeReceiver() {
        skuChangeReceiver = new SkuStateChangeReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction(Base.PUSH_ACTION_SKU_STATE_CHANGED);
        this.registerReceiver(skuChangeReceiver, filter);
    }

    private void unregistSkuChangeReceiver() {
        if (skuChangeReceiver != null) {
            this.unregisterReceiver(skuChangeReceiver);
            skuChangeReceiver = null;
        }
    }

    private void registGoodsChangeReceiver() {
        goodsChangeReceiver = new GoodsChangeReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction(Base.PUSH_ACTION_GOODS_CHANGED);
        this.registerReceiver(goodsChangeReceiver, filter);
    }

    private void unregistGoodsChangeReceiver() {
        if (goodsChangeReceiver != null) {
            this.unregisterReceiver(goodsChangeReceiver);
            goodsChangeReceiver = null;
        }
    }

    private void registTouchReceiver() {
        touchReceiver = new TouchReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction(Base.BROADCAST_ACTION_TOUCH_EVENT);
        this.registerReceiver(touchReceiver, filter);
    }

    private void unregistTouchReceiver() {
        if (touchReceiver != null) {
            this.unregisterReceiver(touchReceiver);
            touchReceiver = null;
        }
    }

    class SkuStateChangeReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                String msgBody = intent.getStringExtra(Base.PUSH_DEFAULT_EXTRA);
                if (StringUtils.isEmpty(msgBody)) {
                    return;
                }

                MainData mainData = HLApplication.getMainData();
                if (mainData == null) {
                    return;
                }
                SkuStateChangedVo stateChangedVo = JsonUtils.getMapper().readValue(msgBody, SkuStateChangedVo.class);
                if (StringUtils.isEmpty(stateChangedVo.getMachineCode())) {
                    return;
                }
                if (!stateChangedVo.getMachineCode().equals(AppConfig.MACHINE_CODE)) {
                    return;
                }
                if (stateChangedVo.getGoodsId() == null || CollectionUtils.isEmpty(stateChangedVo.getSkuIds())) {
                    return;
                }
                SkuState state = SkuState.get(stateChangedVo.getState());
                if (state == null) {
                    return;
                }

                if (!CollectionUtils.isEmpty(mainData.getCategorys())) {
                    mainData.getCategorys().forEach(category -> {
                        if (CollectionUtils.isEmpty(category.getGoods())) {
                            return;
                        }
                        category.getGoods().forEach(goods -> {
                            if (CollectionUtils.isEmpty(goods.getSkus())) {
                                return;
                            }
                            goods.getSkus().forEach(sku -> {
                                if (stateChangedVo.getSkuIds().contains(sku.getSkuId())) {
                                    sku.setState(state.getCode());
                                }
                            });
                        });
                    });
                }

                if (!CollectionUtils.isEmpty(mainData.getRecommends())) {
                    mainData.getRecommends().forEach(recommend -> {
                        if (recommend.getGoods() == null || CollectionUtils.isEmpty(recommend.getGoods().getSkus())) {
                            return;
                        }
                        recommend.getGoods().getSkus().forEach(sku -> {
                            if (stateChangedVo.getSkuIds().contains(sku.getSkuId())) {
                                sku.setState(state.getCode());
                            }
                        });
                    });
                }

                mainDataChanged();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class GoodsChangeReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            loadData();
        }
    }

    class TouchReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            TIMESTAMP = Utils.getTimestamp();
        }
    }

    public static Long TIMESTAMP = System.currentTimeMillis();
    public static Boolean TIMEOUT_TOGGLE = true;
    public static Boolean IN_MAIN = true;

    /** 判断空闲时间定时器 */
    private class TimeoutThread extends Thread {
        @Override
        public void run() {
            super.run();
            try {
                while (true) {
                    Thread.sleep(1000);
                    if (!TIMEOUT_TOGGLE || (IN_MAIN && HLApplication.getGoodsCount() <= 0)) {
                        // 打开确认订单弹窗，停止判断空闲 或 在首页，但购物车没有商品
                        TIMESTAMP = Utils.getTimestamp();
                        continue;
                    }
                    if (Utils.getTimestamp() - TIMESTAMP > 1000 * 30) {
                        TIMESTAMP = Utils.getTimestamp();
                        clearTipHandler.sendEmptyMessage(0);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    Handler clearTipHandler = new Handler() {
        @SuppressLint("HandlerLeak")
        @Override
        public void handleMessage(@NonNull Message msg) {
            Utils.showClearDialog(LauncherActivity.this);
        }
    };
}
