package com.ihaoin.hooloo.device.view;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.app.Presentation;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.AnimationDrawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.ihaoin.hooloo.device.HLApplication;
import com.ihaoin.hooloo.device.R;
import com.ihaoin.hooloo.device.component.IntroViewPager;
import com.ihaoin.hooloo.device.config.Base;
import com.ihaoin.hooloo.device.data.MainData;
import com.ihaoin.hooloo.device.data.vo.KDSMsg;
import com.ihaoin.hooloo.device.data.vo.KDSOrder;
import com.ihaoin.hooloo.device.data.vo.OrderPkg;
import com.ihaoin.hooloo.device.test.KDSGen;
import com.ihaoin.hooloo.device.util.CollectionUtils;
import com.ihaoin.hooloo.device.util.Utils;

import java.util.ArrayList;
import java.util.List;

public class MenuPresentation extends Presentation {

    //    private List<OrderPkg> orderPkgs;
    private KDSMsg mKdsMsg;
//    private LoadOrdersHandler loadOrdersHandler;
//    private OrderStateChangeReceiver orderStateChangeReceiver;

    private IntroViewPager introPager;
//    private List<Order> cookingOrders;
//    private List<Order> waitingOrders;
//    private List<Order> completedOrders;

//    private ImageView imgLeft;
//    private GridView gridCooking;
//    private GridView gridWaiting;
//    private GridView gridCompleted;
//    private OrderAdapter cookingAdapter;
//    private OrderAdapter waitingAdapter;
//    private OrderAdapter completedAdapter;

    private TextView txtOutsideTemp;
    private TextView txtInsideTemp;
    private TextView txtFridgeTemp;
    private TextView txtInsideHumidity;
    private TextView txtTimerClear;
    private TextView txtTimerMaterial;
    private TextView txtTimerUsual;

    private ImageView imgAvatar;
    private List<View> progressViews = new ArrayList<>();
    private List<TextView> waitingViews = new ArrayList<>();
    private List<TextView> completedViews = new ArrayList<>();

    public MenuPresentation(Context outerContext, Display display) {
        super(outerContext, display);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.present_menu);

        initViews();
//        loadDatas();

//        registOrderChangeReceiver();
        registerKDSMessageReceiver();

        setOnDismissListener(dismissListener);

        startPagerThread();
    }

    private void initViews() {
        imgAvatar = findViewById(R.id.img_avatar);
        introPager = findViewById(R.id.intro_pager);
//        imgLeft = findViewById(R.id.img_left);
//        gridCooking = findViewById(R.id.grid_cooking);
//        gridWaiting = findViewById(R.id.grid_waiting);
//        gridCompleted = findViewById(R.id.grid_completed);
//
//        txtSupplement = findViewById(R.id.txt_timer_supplement);
//        txtClear = findViewById(R.id.txt_timer_clear);
//
//        cookingAdapter = new OrderAdapter(getContext());
//        waitingAdapter = new OrderAdapter(getContext());
//        completedAdapter = new OrderAdapter(getContext());
//
//        gridCooking.setAdapter(cookingAdapter);
//        gridWaiting.setAdapter(waitingAdapter);
//        gridCompleted.setAdapter(completedAdapter);

        progressViews.add(findViewById(R.id.progress1));
        progressViews.add(findViewById(R.id.progress2));

        waitingViews.add(findViewById(R.id.waiting1));
        waitingViews.add(findViewById(R.id.waiting2));
        waitingViews.add(findViewById(R.id.waiting3));
        waitingViews.add(findViewById(R.id.waiting4));
        waitingViews.add(findViewById(R.id.waiting5));
        waitingViews.add(findViewById(R.id.waiting6));

        completedViews.add(findViewById(R.id.completed1));
        completedViews.add(findViewById(R.id.completed2));
        completedViews.add(findViewById(R.id.completed3));
        completedViews.add(findViewById(R.id.completed4));
        completedViews.add(findViewById(R.id.completed5));
        completedViews.add(findViewById(R.id.completed6));
        completedViews.add(findViewById(R.id.completed7));
        completedViews.add(findViewById(R.id.completed8));
        completedViews.add(findViewById(R.id.completed9));

        txtOutsideTemp = findViewById(R.id.txt_outside_temp);
        txtInsideTemp = findViewById(R.id.txt_inside_temp);
        txtFridgeTemp = findViewById(R.id.txt_fridge_temp);
        txtInsideHumidity = findViewById(R.id.txt_inside_humidity);
        txtTimerClear = findViewById(R.id.txt_timer_clear);
        txtTimerMaterial = findViewById(R.id.txt_timer_material);
        txtTimerUsual = findViewById(R.id.txt_timer_usual);

        AnimationDrawable anim = (AnimationDrawable) getContext().getDrawable(R.drawable.menu_avatar);
        imgAvatar.setImageDrawable(anim);
        anim.start();
    }

//    private String getRightImage(String state) {
//        MainData mainData = HLApplication.getMainData();
//        if (mainData == null || mainData.getImages() == null) {
//            return null;
//        }
//        if (CollectionUtils.isEmpty(mainData.getImages().getRight())) {
//            return null;
//        }
//        return mainData.getImages().getRight().get(state);
//    }

    private void showImages() {
        MainData mainData = HLApplication.getMainData();
        if (mainData == null || mainData.getImages() == null) {
            return;
        }
        introPager.removeAllViews();
//        List<String> lefts = Arrays.asList("https://hooloo-saas-test.oss-cn-beijing.aliyuncs.com/hooloo/2022/07/08/点单屏内容图-拿铁.png", "https://hooloo-saas-test.oss-cn-beijing.aliyuncs.com/hooloo/2022/07/08/点单屏内容图-拿铁.png");
        if (CollectionUtils.isEmpty(mainData.getImages().getLeft())) {
            return;
        }
        List<View> introViews = new ArrayList<>();
        mainData.getImages().getLeft().forEach(url -> introViews.add(getIntroImage(url)));
        introPager.setIntroViews(introViews);
    }

    private ImageView getIntroImage(String url) {
        ImageView imgIntro = new ImageView(getContext());
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        imgIntro.setLayoutParams(layoutParams);
        imgIntro.setAdjustViewBounds(true);
        Utils.getGlide(getContext()).load(url).into(imgIntro);
        return imgIntro;
    }

    private PagerThread pagerThread;
    private PagerHandler pagerHandler;

    private void startPagerThread() {
        pagerHandler = new PagerHandler();
        pagerThread = new PagerThread();
        pagerThread.start();
    }

    private class PagerThread extends Thread {
        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(1000 * 5);
                    pagerHandler.sendEmptyMessage(1);

                    KDSMsg msg = KDSGen.getKdsMsg();
                    Utils.sendKdsMsgBroadcast(getContext(), msg);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class PagerHandler extends Handler {
        @Override
        public void handleMessage(@NonNull Message msg) {
            int count = introPager.getCount();
            if (count <= 1) {
                return;
            }
            int index = introPager.getCurrentItem();
            if (index + 1 >= count) {
                index = 0;
            } else {
                index++;
            }
            introPager.setCurrentItem(index, true);
        }
    }

    public void mainDataChanged() {
        showImages();
    }

//    private void loadDatas() {
//        loadOrdersHandler = new LoadOrdersHandler();
//        HttpUtil.getOrders(loadOrdersHandler);
//    }
//
//    private void setDatas(String json) {
//        try {
//            orderPkgs = JsonUtils.getMapper().readValue(json, new TypeReference<List<OrderPkg>>() {
//            });
//            orderDataChanged();
////            List<OrderPkg> pkgs = JsonUtils.getMapper().readValue(json, new TypeReference<List<OrderPkg>>() {
////            });
////            setOrders(pkgs);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//    }

//    private void setOrders(List<OrderPkg> pkgs) {
//        try {
//            if (CollectionUtils.isEmpty(pkgs)) {
//                return;
//            }
//            List<Order> cookings = getOrders(pkgs, OrderState.COOKING.getCode());
//            if (CollectionUtils.isEmpty(cookings)) {
//                return;
//            }
//            cookings.forEach(order -> order.setProgress(getProgressByOrder(order)));
//        } catch (Exception e) {
//            e.printStackTrace();
//        } finally {
//            orderPkgs = pkgs;
//            orderDataChanged();
//        }
//    }
//
//    private Integer getProgressByOrder(Order order) {
//        List<Order> cookings = getOrders(OrderState.COOKING.getCode());
//        if (CollectionUtils.isEmpty(cookings)) {
//            return 0;
//        }
//        for (Order o : cookings) {
//            if (o.equals(order)) {
//                return o.getProgress();
//            }
//        }
//        return 0;
//    }

    @SuppressLint("StringFormatMatches")
    private void setMachineState() {
        if (mKdsMsg == null) {
            return;
        }

        txtOutsideTemp.setText(getContext().getString(R.string.txt_outside_temp, mKdsMsg.getOutTemperature()));
        txtInsideTemp.setText(getContext().getString(R.string.txt_inside_temp, mKdsMsg.getInTemperature()));
        txtFridgeTemp.setText(getContext().getString(R.string.txt_fridge_temp, mKdsMsg.getFridgeTemperature()));
        txtInsideHumidity.setText(getContext().getString(R.string.txt_inside_humidity, mKdsMsg.getHumidity()));
        txtTimerClear.setText(getContext().getString(R.string.txt_timer_clear, mKdsMsg.getCoffeeCleanTime()));
        txtTimerMaterial.setText(getContext().getString(R.string.txt_timer_material, mKdsMsg.getChangeMaterialTime()));
        txtTimerUsual.setText(getContext().getString(R.string.txt_timer_usual, mKdsMsg.getDailyCleanTime()));
    }

    private void orderDataChanged() {
        if (mKdsMsg == null) {
            return;
        }
        List<KDSOrder> cookings = mKdsMsg.getCookings();
        List<String> waitings = mKdsMsg.getWaitings();
        List<String> completes = mKdsMsg.getCompleteds();

        cookings = CollectionUtils.subList(cookings, 0, 2);
        waitings = CollectionUtils.subList(waitings, 0, 6);
        completes = CollectionUtils.subList(completes, 0, 9);

        progressViews.forEach(v -> v.setVisibility(View.INVISIBLE));
        waitingViews.forEach(v -> v.setVisibility(View.INVISIBLE));
        completedViews.forEach(v -> v.setVisibility(View.INVISIBLE));

        if (!CollectionUtils.isEmpty(waitings)) {
            for (int i = 0; i < waitings.size(); i++) {
                TextView v = waitingViews.get(i);
                v.setText(waitings.get(i));
                v.setVisibility(View.VISIBLE);
            }
        }
        if (!CollectionUtils.isEmpty(completes)) {
            for (int i = 0; i < completes.size(); i++) {
                TextView v = completedViews.get(i);
                v.setText(completes.get(i));
                v.setVisibility(View.VISIBLE);
            }
        }
        if (!CollectionUtils.isEmpty(cookings)) {
            for (int i = 0; i < cookings.size(); i++) {
                KDSOrder order = cookings.get(i);
                View v = progressViews.get(i);
//                v.setText(cookings.get(i).getOrderNumber());
                TextView orderNum = v.findViewById(R.id.txt_order_number);
                View imgTmp = v.findViewById(R.id.img_tmp);
                ImageView imgMask = v.findViewById(R.id.img_mask);
                TextView txtProgress = v.findViewById(R.id.txt_progress);
                orderNum.setText(order.getOrderNumber());
                txtProgress.setText(order.getProgress() + "%");

                LinearLayout.LayoutParams lpMask = (LinearLayout.LayoutParams) imgMask.getLayoutParams();
                LinearLayout.LayoutParams lpTemp = (LinearLayout.LayoutParams) imgTmp.getLayoutParams();

                ValueAnimator animator = new ValueAnimator();
                animator.setDuration(500);
//                Utils.i(String.format("weight:%s, pro:%s", lpMask.weight, order.getProgress()));
                animator.setIntValues((int) lpTemp.weight, order.getProgress());
                animator.addUpdateListener(animation -> {
                    int progress = (Integer) animation.getAnimatedValue();
                    lpMask.weight = 100 - progress;
                    imgMask.setLayoutParams(lpMask);

                    lpTemp.weight = progress;
                    imgTmp.setLayoutParams(lpTemp);
                });
                animator.start();
                v.setVisibility(View.VISIBLE);

            }
        }

//        cookingAdapter.setOrders(cookings);
//        waitingAdapter.setOrders(waitings);
//        completedAdapter.setOrders(completes);
//
//        cookingAdapter.notifyDataSetChanged();
//        waitingAdapter.notifyDataSetChanged();
//        completedAdapter.notifyDataSetChanged();

        showImages();
    }

//    private List<Order> getOrders(Integer state) {
//        return getOrders(orderPkgs, state);
//    }

//    private List<Order> getOrders(List<OrderPkg> pkgs, Integer state) {
//        if (CollectionUtils.isEmpty(pkgs)) {
//            return null;
//        }
//        Map<Integer, OrderPkg> map = pkgs.stream().collect(Collectors.toMap(OrderPkg::getState, Function.identity()));
//        if (CollectionUtils.isEmpty(map)) {
//            return null;
//        }
//        OrderPkg pkg = map.get(state);
//        if (pkg == null) {
//            return null;
//        }
//        return pkg.getOrders();
//    }

//    class LoadOrdersHandler extends NetworkHandler {
//        @Override
//        public void handleMessage(@NonNull Message msg) {
//            super.handleMessage(msg);
//            if (msg.what != 1) {
//                return;
//            }
////            String body = "[{\"state\":1,\"desc\":\"制作中\",\"orders\":[{\"orderId\":1011,\"orderNo\":\"N20220220A19231\",\"orderNumber\":\"Mon101\"},{\"orderId\":1012,\"orderNo\":\"N20220220A19232\",\"orderNumber\":\"Mon102\"},{\"orderId\":1013,\"orderNo\":\"N20220220A19233\",\"orderNumber\":\"Mon103\"}]},{\"state\":2,\"desc\":\"待制作\",\"orders\":[{\"orderId\":1014,\"orderNo\":\"N20220220A19234\",\"orderNumber\":\"Mon104\"},{\"orderId\":1015,\"orderNo\":\"N20220220A19235\",\"orderNumber\":\"Mon105\"},{\"orderId\":1016,\"orderNo\":\"N20220220A19236\",\"orderNumber\":\"Mon106\"},{\"orderId\":1017,\"orderNo\":\"N20220220A19237\",\"orderNumber\":\"Mon107\"},{\"orderId\":1018,\"orderNo\":\"N20220220A19238\",\"orderNumber\":\"Mon108\"}]},{\"state\":3,\"desc\":\"可取餐\",\"orders\":[{\"orderId\":1019,\"orderNo\":\"N20220220A19239\",\"orderNumber\":\"Mon109\"},{\"orderId\":1001,\"orderNo\":\"N20220220A19221\",\"orderNumber\":\"Mon121\"},{\"orderId\":1002,\"orderNo\":\"N20220220A19222\",\"orderNumber\":\"Mon122\"},{\"orderId\":1003,\"orderNo\":\"N20220220A19223\",\"orderNumber\":\"Mon123\"},{\"orderId\":1004,\"orderNo\":\"N20220220A19224\",\"orderNumber\":\"Mon124\"},{\"orderId\":1005,\"orderNo\":\"N20220220A19241\",\"orderNumber\":\"Mon141\"},{\"orderId\":1006,\"orderNo\":\"N20220220A19251\",\"orderNumber\":\"Mon151\"}]}]";
//            if (msg.obj == null) {
//                return;
//            }
//            String body = msg.obj.toString();
//            if (StringUtils.isEmpty(body)) {
//                return;
//            }
//            setDatas(body);
//        }
//    }

//    private void registOrderChangeReceiver() {
//        orderStateChangeReceiver = new OrderStateChangeReceiver();
//        IntentFilter filter = new IntentFilter();
//        filter.addAction(Base.PUSH_ACTION_ORDER_STATE_CHANGED);
//        getContext().registerReceiver(orderStateChangeReceiver, filter);
//    }
//
//    private void unregistOrderChangeReceiver() {
//        if (orderStateChangeReceiver != null) {
//            getContext().unregisterReceiver(orderStateChangeReceiver);
//            orderStateChangeReceiver = null;
//        }
//    }
//
//    class OrderStateChangeReceiver extends BroadcastReceiver {
//        @Override
//        public void onReceive(Context context, Intent intent) {
//            try {
//                String msgBody = intent.getStringExtra(Base.PUSH_DEFAULT_EXTRA);
//                if (StringUtils.isEmpty(msgBody)) {
//                    return;
//                }
//
//                Order order = JsonUtils.getMapper().readValue(msgBody, Order.class);
//                if (order == null || order.getState() == null || order.getOrderId() == null || order.getOrderId() <= 0
//                        || StringUtils.isEmpty(order.getOrderNo()) || StringUtils.isEmpty(order.getOrderNumber())) {
//                    return;
//                }
//
//                if (CollectionUtils.isEmpty(orderPkgs)) {
//                    OrderState state = OrderState.get(order.getState());
//                    if (state == null) {
//                        return;
//                    }
//                    orderPkgs = new ArrayList<>();
//
//                    List<Order> orders = new ArrayList<>();
//                    orders.add(order);
//                    OrderPkg pkg = new OrderPkg();
//                    pkg.setState(order.getState());
//                    pkg.setOrders(orders);
//                    orderPkgs.add(pkg);
//                } else {
//                    // 删除订单
//                    orderPkgs.forEach(pkg -> {
//                        if (CollectionUtils.isEmpty(pkg.getOrders())) {
//                            return;
//                        }
//                        pkg.getOrders().remove(order);
//                    });
//
//                    OrderState state = OrderState.get(order.getState());
//                    if (state == null) {
//                        return;
//                    }
//                    // 添加新订单状态
//                    OrderPkg pkg = getOrdersByState(orderPkgs, order.getState());
//                    if (pkg == null) {
//                        List<Order> orders = new ArrayList<>();
//                        orders.add(order);
//                        pkg = new OrderPkg();
//                        pkg.setState(order.getState());
//                        pkg.setOrders(orders);
//                        orderPkgs.add(pkg);
//                    } else {
//                        List<Order> orders = pkg.getOrders();
//                        if (CollectionUtils.isEmpty(orders)) {
//                            orders = new ArrayList<>();
//                        }
//                        orders.add(order);
//                        pkg.setOrders(orders);
//                    }
//                }
//            } catch (Exception e) {
//                e.printStackTrace();
//            } finally {
//                orderDataChanged();
//            }
//        }
//    }

    private OrderPkg getOrdersByState(List<OrderPkg> pkgs, Integer state) {
        if (CollectionUtils.isEmpty(pkgs)) {
            return null;
        }
        for (OrderPkg pkg : pkgs) {
            if (pkg.getState().equals(state)) {
                return pkg;
            }
        }
        return null;
    }

    OnDismissListener dismissListener = new OnDismissListener() {
        @Override
        public void onDismiss(DialogInterface dialog) {
            Utils.i("menu present dismiss");
//            unregistOrderChangeReceiver();
            unregistKDSMessageReceiver();

//            if (loadOrdersHandler != null) {
//                loadOrdersHandler.removeCallbacksAndMessages(null);
//                loadOrdersHandler = null;
//            }
            if (pagerHandler != null) {
                pagerHandler.removeCallbacksAndMessages(null);
                pagerHandler = null;
            }
            if (pagerThread != null) {
                pagerThread.interrupt();
                pagerThread = null;
            }
        }
    };

    private KDSMessageReceiver mKDSMessageReceiver = null;

    private void registerKDSMessageReceiver() {
        mKDSMessageReceiver = new KDSMessageReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction(Base.BROADCAST_ACTION_KDS_INFO);
        getContext().registerReceiver(mKDSMessageReceiver, filter);
    }

    private void unregistKDSMessageReceiver() {
        if (mKDSMessageReceiver != null) {
            getContext().unregisterReceiver(mKDSMessageReceiver);
            mKDSMessageReceiver = null;
        }
    }

    private class KDSMessageReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            KDSMsg msg = (KDSMsg) intent.getSerializableExtra("msg");
            if (msg == null) {
                return;
            }
            mKdsMsg = msg;
            orderDataChanged();
            setMachineState();
        }
    }
}
