package com.ihaoin.hooloo.device.view;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.pm.PackageInfo;
import android.os.Bundle;
import android.view.View;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.ToggleButton;

import com.ihaoin.hooloo.device.R;
import com.ihaoin.hooloo.device.config.Base;
import com.ihaoin.hooloo.device.data.enums.PresentState;
import com.ihaoin.hooloo.device.util.SharedPreferencesUtils;
import com.ihaoin.hooloo.device.util.StringUtils;
import com.ihaoin.hooloo.device.util.Utils;

public class SettingsActivity extends Activity {

    private View layoutTest;
    private View layoutSysSettings;
    private TextView txtVersion;
    private TextView txtMachineCode;
    private View layoutMachineCode;
    private View layoutScreen;
    private View layoutPresentation;
    private TextView txtScreenNo;
    private TextView txtPresentation;

    private ToggleButton butnLogcat;
    private View butnClose;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_settings);
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        initViews();
        LauncherActivity.IN_MAIN = false;
    }

    private void initViews() {
        layoutTest = findViewById(R.id.layout_test);
        layoutSysSettings = findViewById(R.id.layout_sys_settings);
        txtVersion = findViewById(R.id.txt_version);
        txtMachineCode = findViewById(R.id.txt_machine_code);
        layoutMachineCode = findViewById(R.id.layout_machine_code);
        layoutScreen = findViewById(R.id.layout_screen);
        txtScreenNo = findViewById(R.id.txt_screen_no);
        layoutPresentation = findViewById(R.id.layout_presentation);
        txtPresentation = findViewById(R.id.txt_presentation);
        butnLogcat = findViewById(R.id.butn_logcat);
        butnClose = findViewById(R.id.butn_close);

        txtVersion.setText(getAppVersionName());
        txtMachineCode.setText(SharedPreferencesUtils.getMachineCode(this));
        txtScreenNo.setText(SharedPreferencesUtils.getScreenNo(this));
        txtPresentation.setText(SharedPreferencesUtils.getPresentation(this));
        butnLogcat.setChecked(SharedPreferencesUtils.getShowLogcat(this));

        layoutTest.setOnClickListener(v -> Utils.showTest(SettingsActivity.this));
        butnLogcat.setOnCheckedChangeListener((v, checked) -> {
            SharedPreferencesUtils.setShowLogcat(SettingsActivity.this, checked);
            Utils.fastBroadcast(SettingsActivity.this, Base.BROADCAST_ACTION_LOGCAT_STATE_CHANGED);
        });
        butnClose.setOnClickListener(v -> finish());
        layoutScreen.setOnClickListener(v -> showEditScreen());
        layoutMachineCode.setOnClickListener(v -> showMachineCode());
        layoutPresentation.setOnClickListener(v -> showEditPresentation());
        layoutSysSettings.setOnClickListener(v -> Utils.openSystemSettings(getApplicationContext()));
    }

    private void showEditScreen() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("修改点单屏编码");
        String[] items = new String[]{"1", "2"};
        builder.setSingleChoiceItems(items, StringUtils.indexOf(items, SharedPreferencesUtils.getScreenNo(SettingsActivity.this)), (dialog, which) -> {
            SharedPreferencesUtils.setScreenNo(SettingsActivity.this, items[which]);
            txtScreenNo.setText(SharedPreferencesUtils.getScreenNo(SettingsActivity.this));
            dialog.dismiss();
        });
        builder.create().show();
    }

    private void showEditPresentation() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("修改副屏内容");
        String[] items = new String[]{PresentState.NONE.getName(), PresentState.MENU.getName(), PresentState.INTERACTION.getName()};
        builder.setSingleChoiceItems(items, StringUtils.indexOf(items, SharedPreferencesUtils.getPresentation(SettingsActivity.this)), (dialog, which) -> {
            SharedPreferencesUtils.setPresentation(SettingsActivity.this, items[which]);
            txtPresentation.setText(SharedPreferencesUtils.getPresentation(SettingsActivity.this));
            dialog.dismiss();
            Utils.fastBroadcast(SettingsActivity.this, Base.BROADCAST_ACTION_PRESENT_CHANGED);
        });
        builder.create().show();
    }

    private void showMachineCode() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("修改机器编码");
        EditText editText = new EditText(getApplicationContext());
        editText.setText(SharedPreferencesUtils.getMachineCode(SettingsActivity.this));
        builder.setView(editText);
        builder.setPositiveButton("确定", (dialog, which) -> {
            SharedPreferencesUtils.setMachineCode(SettingsActivity.this, editText.getText().toString());
            txtMachineCode.setText(SharedPreferencesUtils.getMachineCode(SettingsActivity.this));
            Utils.fastBroadcast(SettingsActivity.this, Base.BROADCAST_ACTION_MACHINE_CODE_CHANGED);
        });
        builder.setNegativeButton("取消", null);
        builder.create().show();
    }

    public String getAppVersionName() {
        try {
            PackageInfo packageInfo = getApplicationContext().getPackageManager().getPackageInfo(getPackageName(), 0);
            return packageInfo.versionName;
        } catch (Exception e) {
        }
        return null;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        LauncherActivity.IN_MAIN = true;
    }
}
