package com.ihaoin.hooloo.device.view;

import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import androidx.annotation.NonNull;

import com.ihaoin.hooloo.device.HLApplication;
import com.ihaoin.hooloo.device.R;
import com.ihaoin.hooloo.device.config.Base;
import com.ihaoin.hooloo.device.util.StringUtils;
import com.ihaoin.hooloo.device.util.Utils;

public class TipsDialog extends Dialog {
    private View butnClose;
    private WebView webView;

    public TipsDialog(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dialog_tips);
        if (HLApplication.getMainData() == null || StringUtils.isEmpty(HLApplication.getMainData().getTips())) {
            dismiss();
            return;
        }
        initViews();
        registTimeoutReceiver();
        LauncherActivity.IN_MAIN = false;
    }

    private void initViews() {
        webView = findViewById(R.id.web_view);
        butnClose = findViewById(R.id.butn_close);

        webView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                return false;
            }
        });
        webView.loadUrl(HLApplication.getMainData().getTips());
        butnClose.setOnClickListener(x -> dismiss());

//        Utils.setTouchDelegate(findViewById(R.id.layout_root), Arrays.asList(butnClose));
        setOnDismissListener(dismissListener);
    }

    @Override
    public boolean dispatchTouchEvent(@NonNull MotionEvent ev) {
        Utils.fastBroadcast(getContext(), Base.BROADCAST_ACTION_TOUCH_EVENT);
        return super.dispatchTouchEvent(ev);
    }

    OnDismissListener dismissListener = dialog -> {
        unregistTimeoutReceiver();
        LauncherActivity.IN_MAIN = true;
    };

    private TimeoutReceiver timeoutReceiver;

    class TimeoutReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            dismiss();
        }
    }

    private void registTimeoutReceiver() {
        timeoutReceiver = new TimeoutReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction(Base.BROADCAST_ACTION_TIMEOUT);
        this.getContext().registerReceiver(timeoutReceiver, filter);
    }

    private void unregistTimeoutReceiver() {
        if (timeoutReceiver != null) {
            this.getContext().unregisterReceiver(timeoutReceiver);
            timeoutReceiver = null;
        }
    }
}
