// initToast.js
import Vuex from 'vuex'
export default function initToast(v) {
  // 挂在store到全局Vue原型上
  v.prototype.$toastStore = new Vuex.Store({
    state: {
		show:false,
		title:"标题",
        time:2000
    },
    mutations: {
		hideToast(state) {
			// #ifndef 
			if(state.hideTabBar){
				wx.showTabBar();
			}
			// #endif
			state.show = false;
		},
		showToast(state,data) {
			state = Object.assign(state,data)
			state.show = true
			if (!state.buttonShow) {
				setTimeout(()=>{
					state.show = false
					return 
				},state.time)	
			}
		},
    }
  })
  v.prototype.showToast = function (option) { 
	if (typeof option === 'object') {
		if(option.hideTabBar){
			wx.hideTabBar();
		}
		v.prototype.$toastStore.commit('showToast', option)
	}
  }
}
