import Vue from 'vue';
import Vuex from 'vuex';
import user from './modules/user';
import menu from './modules/menu';
import order from './modules/order'
import getters from './getters';
Vue.use(Vuex);
const store = new Vuex.Store({
  modules: {
    user,
    menu,
    order
  },
  state: {
    list: [],

    orderId: '', //外部扫码进入的商品id
  },
  mutations: {
    // 设置扫码进入的商品id
    setOrderId(state, orderId) {
      state.orderId = orderId;
    },
  },
  getters,
  actions: {},
});
export default store;
