import App from './App';
//引入vuex
import store from './store';
import utils from './utils/utils';

// console.log(Vue.$u,22)
// 需要在Vue.use(uView)之后执行
// #ifndef VUE3
import Vue from 'vue';
import Vuex from 'vuex'
import uView from 'uview-ui';
import User from '@/request/user';

// main.js
import initToast from "@/components/bocft-toast/initToast.js"
import showToast from "@/components/bocft-toast/bocft-toast.vue"
import taBar from "@/components/tabBar/tabBar.vue"

initToast(Vue);
Vue.component('show-toast',showToast);
Vue.component('taBar',taBar);


Vue.use(uView);
Vue.prototype.$utils = utils;
Vue.prototype.setPrice = (price) => price && Number(price).toFixed(2);

Vue.prototype.loginByPhoneNumber = (e) => {
  if (e.detail.errMsg == 'getPhoneNumber:ok') {
    User.getPhoneNumber(e);
  } else if (e.detail.errMsg == 'getPhoneNumber:fail user deny') {
    uni.showToast({ title: '已拒绝手机号授权', icon: 'error' });
  }
};

Vue.config.productionTip = false;

App.mpType = 'app';
const app = new Vue({
  ...App,
  store,
});
export default app
app.$mount();
require('./request/index')(app);
// #endif

// #ifdef VUE3
import { createSSRApp } from 'vue';
export function createApp() {
  const app = createSSRApp(App);
  return {
    app,
  };
}
// #endif
