export default {
  getMyOrder() {
    return uni.$u.http
      .get('/app/getMyOrder', {
        params: {},
        custom: {noLoading: true},
      })
      .then((res) => res)
      .catch((err) => {
        // uni.showToast({ title: '服务器错误', icon: 'none' })
        console.log('服务器错误');
      });
  },
  orderRefund(data) {
    return uni.$u.http
      .post('/system/refund', data)
      .then((res) => res)
      .catch((err) => {
        // uni.showToast({ title: '服务器错误', icon: 'none' })
        console.log('服务器错误');
      });
  },
  getShop(params) {
    return uni.$u.http
      .get('/weixin/getArea', {
        params,
      })
      .then((res) => res)
      .catch((err) => {
        // uni.showToast({ title: '服务器错误', icon: 'none' })
        console.log('服务器错误');
      });
  },
  // 校验sku是否可用
  chekSku(params) {
    return uni.$u.http
      .get('/application/checkSku', {
        params,
      })
      .then((res) => res)
      .catch((err) => {
        // uni.showToast({ title: '服务器错误', icon: 'none' })
        console.log('服务器错误');
      });
  },
  cancelOrder(params) {
    return uni.$u.http
      .get('order/cancel', {
        params,
      })
      .then((res) => res)
      .catch((err) => {
        // uni.showToast({ title: '服务器错误', icon: 'none' })
        console.log('服务器错误');
      });
  },
  // 立即支付
  payOrder(params) {
    return uni.$u.http
      .get('order/payOrder', {
        params,
      })
      .then((res) => res)
      .catch((err) => {
        // uni.showToast({ title: '服务器错误', icon: 'none' })
        console.log('服务器错误');
      });
  },
  getHomeOrder(params) {
    return uni.$u.http
      .get(`/app/getHomeOrder?shopId=${params.shopId}`, {
        params: {},
        custom: {noLoading: true},
      })
      .then((res) => res)
      .catch((err) => {
        // uni.showToast({ title: '服务器错误', icon: 'none' })
        console.log('服务器错误');
      });
  },
  getWaitTine(data) {
    return uni.$u.http
      .post('app/getWaitTine', data)
      .then((res) => res)
      .catch((err) => {
        // uni.showToast({ title: '服务器错误', icon: 'none' })
        console.log('服务器错误');
      });
  },
  moreOrder(params) {
    return uni.$u.http
      .get('/app/getNextOrder', {
        params,
      })
      .then((res) => res)
      .catch((err) => {
        // uni.showToast({ title: '服务器错误', icon: 'none' })
        console.log('服务器错误');
      });
  },
  checkSku(params) {
    const shopInfo = JSON.parse(uni.getStorageSync('shopInfo'))
    return uni.$u.http
      .get(`/application/checkSku?shopId=${shopInfo.id}&skuId=${params.skuId}`)
      .then((res) => res)
      .catch((err) => {
        // uni.showToast({ title: '服务器错误', icon: 'none' })
        console.log('服务器错误');
      });
  },
  getOrderDetail(params) {
    return uni.$u.http
      .get(`/order/${params.orderId}`)
      .then((res) => res)
      .catch((err) => {
        // uni.showToast({ title: '服务器错误', icon: 'none' })
        console.log('服务器错误');
    });
  },
  getOrderWaiteTime(params) {
    return uni.$u.http
      .get(`/app/getWaitTineByOrderId?orderId=${params.orderId}`)
      .then((res) => res)
      .catch((err) => {
        // uni.showToast({ title: '服务器错误', icon: 'none' })
        console.log('服务器错误');
  });
  }
};
