import { $EventBus } from '@/utils/EventBus';
import context from '../../main.js'
import Order from '@/request/order/index.js'
export default {
  // 获取菜单列表
  getMenuList(id) {
    return uni.$u.http
      .get('/weixin/infoByShop', {
        params: {
          shopId: id,
        },
      })
      .then((res) => {
        return res;
      })
      .catch((err) => {
        context.showToast({ title: '服务器错误', icon: 'none' });
      });
  },
  // 获取点单屏幕的订单信息
  getScreenShopCar(key, location) {
    return uni.$u.http
      .post('/application/getData', {
        key,
        location,
      })
      .then((res) => {
        return res;
      })
      .catch((err) => {
        context.showToast({
          title: '服务器错误',
          icon: 'none',
        });
        return err;
      });
  },
  // 下单获取预支付订单
  saveReserve(data) {
    return uni.$u.http
      .post('/order', data)
      .then((res) => {
        return res;
      })
      .catch((err) => { });
  },
  // saveReserve 为业务接口
  requestPayment(data, oldData, buyType) {
    // res为调起微信支付所需参数
    // 调起微信支付
    const { switchTab = true, callBack } = data
    uni.requestPayment({
      provider: 'wxpay', // 服务提提供商微信支付
      timeStamp: data.timeStamp, // 时间戳
      nonceStr: data.nonceStr, // 随机字符串
      package: data.package,
      signType: data.signType || 'MD5', // 签名算法
      paySign: data.paySign, // 签名
      success: async function (res) {
        if (res.errMsg == 'requestPayment:ok') {
          // 删除购物车数据后重新放回购物车
          uni.setStorageSync('shopCarInfo', []);
          $EventBus.$emit('updateCar');
          uni.setStorageSync('orderId', data.orderId);
          if(switchTab){
            let url = '/orderSubPackage/pages/orderInfo/index?from=settlement'
            uni.navigateTo({ url })
          }else{
            callBack()
          }
        }

        // 业务逻辑。。。
      },
      fail: async function (err) {
        context.showToast({
          title: '支付失败',
          icon: 'error',
        });
        uni.setStorageSync('shopCarInfo', []);
        $EventBus.$emit('updateCar');
		  	uni.setStorageSync('orderId', data.orderId);
        if(switchTab){
          let url = '/orderSubPackage/pages/orderInfo/index?from=settlement'
          uni.navigateTo({ url })
        }else{
          callBack()
        }
      },
    });
  },
  // 优惠卷信息接口 
  requestTicketList(data){
    return uni.$u.http
    .post('/app/order/coupon/info', data)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      context.showToast({
        title: '服务器错误',
        icon: 'none',
      });
      return err;
    });
  },
  // 下单页面优惠卷可用数量
  requestTicketNum(data){
    return uni.$u.http
    .post('/app/order/coupon/fitable-count', data)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      context.showToast({
        title: '服务器错误',
        icon: 'none',
      });
      return err;
    });
  }
};
