import context from '../../main.js'
export default {
  getList(id) {},
  getMsg() {
    return uni.$u.http
      .get('/system/message/list', {})
      .then((res) => {
        return res;
      })
      .catch((err) => {
        context.showToast({ title: '服务器错误', icon: 'none' });
      });
  },
  read(data) {
    return uni.$u.http
      .put('/system/message', data)
      .then((res) => {
        return res;
      })
      .catch((err) => {
        context.showToast({ title: '服务器错误', icon: 'none' });
      });
  },
  getMessageCount() {
    return uni.$u.http
      .get('/app/getMessageCount', {})
      .then((res) => {
        return res;
      })
      .catch((err) => {
        context.showToast({ title: '服务器错误', icon: 'none' });
      });
  },
  // 获取用户优惠卷列表
  getUserList(data) {
    return uni.$u.http
    .get(`/app/coupon/list/${data}`, {})
    .then((res) => {
      return res;
    })
    .catch((err) => {
      context.showToast({ title: '服务器错误', icon: 'none' });
    });
  },
  // 获取用户信息
  getUserInfo() {
    return uni.$u.http
    .get(`/system/customer/detail`, {})
    .then((res) => {
      return res;
    })
    .catch((err) => {
      context.showToast({ title: '服务器错误', icon: 'none' });
    });
  },
  // 更改用户生日
  editBirthdat(data) {
    return uni.$u.http
    .post(`/system/customer/update/birth`, data)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      context.showToast({ title: err.data.msg, icon: 'none' });
      return err
    });
  },
  // 更改用户昵称、性别
  editUserInfo(data) {
    return uni.$u.http
    .post(`/system/customer/update/base`, data)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      context.showToast({ title: '服务器错误', icon: 'none' });
    });
  }
};
