package com.soss.common.enums;

/**
 * 机器状态枚举类
 */
public enum MachineState {
    INIT(0, "初始状态"),
    TO_BE_INIT(1, "待初始化"),
    TO_BE_BIND(2, "待绑定店铺"),
    TO_BE_TEST(3, "待运营测试"),
    RUNNING(4, "运行中"),
    STANDBY(5, "待机中"),
    SHUTDOWN(6, "关闭"),
    OPERATING(7, "运维中"),
    RETURN_FACTORY(8, "返厂");

    private Integer state;
    private String desc;

    MachineState(Integer state, String desc) {
        this.state = state;
        this.desc = desc;
    }

    public Integer getState() {
        return state;
    }

    public static String getDesc(Integer state) {
        for (MachineState machineState : MachineState.values()) {
            if (machineState.state.equals(state)) {
                return machineState.desc;
            }
        }
        return null;
    }
}
