package com.soss.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.soss.common.annotation.Excel;
import com.soss.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 店铺对象 shop
 *
 * @author zxq
 * @date 2022-04-28
 */
@Data
public class Shop extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private long id;

    /** 店铺名称 */
    @Excel(name = "店铺名称")
    private String name;

    /** 店铺编码 */
    @Excel(name = "店铺编码")
    private String code;

    /** 店铺位置经度 */
    @Excel(name = "店铺位置经度")
    private String lng;

    /** 店铺位置纬度 */
    @Excel(name = "店铺位置纬度")
    private String lat;

    /**
     * 店铺备注
     */
    @Excel(name = "店铺备注")
    private String remarks;

    /**
     * 店铺开始营业时间
     */
    @Excel(name = "店铺开始营业时间")
    private String startTime;

    /**
     * 店铺结束营业时间
     */
    @Excel(name = "店铺结束营业时间")
    private String endTime;

    /**
     * 店铺地址
     */
    @Excel(name = "店铺地址")
    private String address;

    /**
     * $column.columnComment
     */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private String province;

    /**
     * $column.columnComment
     */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private String city;

    /**
     * $column.columnComment
     */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private String zone;

    @ApiModelProperty("最远下单距离，单位：km")
    private Double distanceLimit;

    /**
     * 店铺状态 1 正常 2 暂停营业 3 关闭
     */
    @Excel(name = "店铺状态 1 正常 2 暂停营业 3 关闭")
    private Integer state;

    /**
     * 状态集合，查询时用
     */
    private List<Integer> states;

    private String distance;

    private Double realDistance;

    private String machieStatus;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    private String machineCode;

    /**
     * 是否默认 0否1是
     */
    @Excel(name = "是否默认 0否1是")
    private Long isDefault;

    private int machineCount;

    /**
     *
     */
    private BigDecimal salesAmount;

    private Integer salesVolume;

    /**
     * 是否允许下单, 1-可以下单，0-不可以下单
     */
    private Integer orderState;
    /**
     * 不允许下单原因
     */
    private String stateDesc;

    public Shop() {
        super();
    }

    public Shop(long id, Integer state) {
        this();
        this.id = id;
        this.state = state;
    }

    public Shop(long id, String code, String name) {
        this();
        this.id = id;
        this.code = code;
        this.name = name;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("name", getName())
                .append("code", getCode())
                .append("lng", getLng())
                .append("lat", getLat())
                .append("remarks", getRemarks())
                .append("startTime", getStartTime())
                .append("endTime", getEndTime())
                .append("address", getAddress())
                .append("province", getProvince())
                .append("city", getCity())
                .append("zone", getZone())
                .append("state", getState())
                .append("createdAt", getCreatedAt())
                .append("updatedAt", getUpdatedAt())
                .append("isDefault", getIsDefault())
                .toString();
    }
}
