package com.soss.system.mapper;

import com.soss.system.domain.CouponRule;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 优惠券规则 Mapper 接口
 * </p>
 *
 * @author caiyt
 * @since 2022-07-21
 */
public interface CouponRuleMapper {
    /**
     * 新增优惠券规则
     *
     * @param couponRule 优惠券规则
     * @return 结果
     */
    int insertCouponRule(CouponRule couponRule);

    /**
     * 更新优惠券规则
     *
     * @param couponRule 优惠券规则
     * @return 结果
     */
    int updateCouponRule(CouponRule couponRule);

    /**
     * 查询优惠券规则详情
     *
     * @param id
     * @return
     */
    CouponRule selectCouponRuleById(Integer id);

    /**
     * 查询优惠券规则列表
     *
     * @param ids
     * @return
     */
    List<CouponRule> selectCouponRuleByIds(@Param("ids") List<Integer> ids);
}
