package com.soss.system.mapper;

import java.util.List;
import com.soss.system.domain.WechatMessage;

/**
 * 小程序信息发送Mapper接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface WechatMessageMapper 
{
    /**
     * 查询小程序信息发送
     * 
     * @param id 小程序信息发送主键
     * @return 小程序信息发送
     */
    public WechatMessage selectWechatMessageById(String id);

    /**
     * 查询小程序信息发送列表
     * 
     * @param wechatMessage 小程序信息发送
     * @return 小程序信息发送集合
     */
    public List<WechatMessage> selectWechatMessageList(WechatMessage wechatMessage);

    /**
     * 新增小程序信息发送
     * 
     * @param wechatMessage 小程序信息发送
     * @return 结果
     */
    public int insertWechatMessage(WechatMessage wechatMessage);

    /**
     * 修改小程序信息发送
     * 
     * @param wechatMessage 小程序信息发送
     * @return 结果
     */
    public int updateWechatMessage(WechatMessage wechatMessage);

    /**
     * 删除小程序信息发送
     * 
     * @param id 小程序信息发送主键
     * @return 结果
     */
    public int deleteWechatMessageById(String id);

    /**
     * 批量删除小程序信息发送
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWechatMessageByIds(String[] ids);
}
