package com.soss.system.service;

import java.util.List;
import com.soss.system.domain.GoodsTag;

/**
 * 商品标签Service接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface IGoodsTagService 
{
    /**
     * 查询商品标签
     * 
     * @param id 商品标签主键
     * @return 商品标签
     */
    public GoodsTag selectGoodsTagById(String id);

    /**
     * 查询商品标签列表
     * 
     * @param goodsTag 商品标签
     * @return 商品标签集合
     */
    public List<GoodsTag> selectGoodsTagList(GoodsTag goodsTag);

    /**
     * 新增商品标签
     * 
     * @param goodsTag 商品标签
     * @return 结果
     */
    public int insertGoodsTag(GoodsTag goodsTag);

    /**
     * 修改商品标签
     * 
     * @param goodsTag 商品标签
     * @return 结果
     */
    public int updateGoodsTag(GoodsTag goodsTag);

    /**
     * 批量删除商品标签
     * 
     * @param ids 需要删除的商品标签主键集合
     * @return 结果
     */
    public int deleteGoodsTagByIds(String[] ids);

    /**
     * 删除商品标签信息
     * 
     * @param id 商品标签主键
     * @return 结果
     */
    public int deleteGoodsTagById(String id);
}
