package com.soss.web.controller.coffee;

import com.soss.common.annotation.Log;
import com.soss.common.core.controller.BaseController;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.core.page.TableDataInfo;
import com.soss.common.enums.BusinessType;
import com.soss.system.domain.Machine;
import com.soss.system.service.IMachineService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 机器Controller
 * 
 * @author zxq
 * @date 2022-04-28
 */
@RestController
@RequestMapping("/system/machine")
public class MachineController extends BaseController
{
    @Autowired
    private IMachineService machineService;

    /**
     * 查询机器列表
     */
   // @PreAuthorize("@ss.hasPermi('system:machine:list')")
    @GetMapping("/list")
    public TableDataInfo list(Machine machine)
    {
        startPage();
        List<Machine> list = machineService.selectMachineList(machine);
        return getDataTable(list);
    }
    /**
     * 绑定机器
     */
    @Log(title = "机器", businessType = BusinessType.INSERT)
    @GetMapping("/bindMachine")
    public AjaxResult bindMachine(String code,Long shopId)
    {
        return AjaxResult.success(machineService.bindMachine(code,shopId));
    }

    /**
     * 获取机器详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:machine:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return AjaxResult.success(machineService.selectMachineById(id));
    }

    /**
     * 新增机器
     */
    @PreAuthorize("@ss.hasPermi('system:machine:add')")
    @Log(title = "机器", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Machine machine)
    {
        return toAjax(machineService.insertMachine(machine));
    }

    /**
     * 解绑机器
     */
    @Log(title = "机器", businessType = BusinessType.UPDATE)
    @GetMapping("/unbound")
    public AjaxResult unbound(String id) {
        return toAjax(machineService.unbound(id));
    }

    @GetMapping("/bind/check/{shopId}")
    public AjaxResult isShopBindMachine(@PathVariable Long shopId) {
        List<Machine> machines = machineService.getMachines(shopId);
        return AjaxResult.success(!CollectionUtils.isEmpty(machines));
    }
}
