package com.soss.common.enums;

/**
 * 退款状态枚举类
 */
public enum RefundState {
    PENDING(0, "待退款"),
    REFUNDING(1, "退款中"),
    SUCCESS(2, "退款成功"),
    FAILURE(3, "退款失败");

    private Integer state;
    private String desc;

    RefundState(Integer state, String desc) {
        this.state = state;
        this.desc = desc;
    }

    public Integer getState() {
        return state;
    }

    public static String getDesc(Integer state) {
        for (RefundState refundState : RefundState.values()) {
            if (refundState.state.equals(state)) {
                return refundState.desc;
            }
        }
        return null;
    }
}
