package com.soss.system.config;


import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class WeChatPayConfig {

    @Value("${weixin.appid}")
    private String appid;

    @Value("${weixin.secret}")
    private String secret;
    @Value("${weixin.mchid}")
    private String mchId;
    @Value("${weixin.key}")
    private String key;
    @Value("${weixin.notify-url}")
    private String notifyUrl;
    @Value("${weixin.trade-type}")
    private String tradeType;
    @Value("${weixin.url}")
    private String url;
    @Value("${weixin.query-url}")
    private String queryUrl;

    @Value("${weixin.cert-path}")
    private String certPath;
    @Bean
    @ConditionalOnMissingBean
    public WxPayConfig payConfig() {
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setAppId(appid);
        payConfig.setMchId(mchId);
        payConfig.setMchKey(key);
        payConfig.setKeyPath(certPath);
        payConfig.setTradeType("JSAPI");
        payConfig.setNotifyUrl(notifyUrl);
        return payConfig;
    }

    @Bean
    public WxPayService wxPayService(WxPayConfig payConfig) {
        WxPayService wxPayService = new WxPayServiceImpl();
        wxPayService.setConfig(payConfig);
        return wxPayService;
    }
}