package com.soss.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.soss.common.annotation.Excel;
import com.soss.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;
import java.util.List;

/**
 * 商品分类对象 goods_category
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Data
public class GoodsCategory extends BaseEntity {
    /**
     * 主键
     */
    private Long id;

    /**
     * 分类名称
     */
    @Excel(name = "分类名称")
    private String name;

    @ApiModelProperty("图标地址")
    private String icon;

    /**
     * 分类备注
     */
    @Excel(name = "分类备注")
    private String remarks;

    /**
     * 排序小的在前
     */
    @Excel(name = "排序小的在前")
    private String turn;

    /**
     * 状态 1 正常 2 停用
     */
    @Excel(name = "状态 1 正常 2 停用")
    private String state;

    /** 0 正常 1 删除 */
    @Excel(name = "0 正常 1 删除")
    private String isDeleted;

    /**商品数量**/
    private Integer goodsCount;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    /** 商品分类编码 */
    @Excel(name = "商品分类编码")
    private String code;

    private List<Goods> goodsList;

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("name", getName())
            .append("remarks", getRemarks())
            .append("turn", getTurn())
            .append("state", getState())
            .append("isDeleted", getIsDeleted())
            .append("createdAt", getCreatedAt())
            .append("updatedAt", getUpdatedAt())
            .append("code", getCode())
            .toString();
    }
}
