package com.soss.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.soss.common.annotation.Excel;
import com.soss.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 由规格选项组合生成商品sku对象 goods_sku
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Data
public class GoodsSku extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private long id;

    /** 商品ID */
    @Excel(name = "商品ID")
    private long goodsId;

    /** 所有规格选项组合，形如 [{"spec_id:1,"rule_id"2"}] */
    @Excel(name = "所有规格选项组合，形如 [{'spec_id:1,'rule_id'2'}]")
    private String ruleList;

    /** 是否删除0否1是 */
    @Excel(name = "是否删除0否 1-自动删除 2-手动删除")
    private Integer isDeleted;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    /** 价格 */
    @Excel(name = "价格")
    private BigDecimal price;

    private BigDecimal discount;

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("goodsId", getGoodsId())
            .append("ruleList", getRuleList())
            .append("isDeleted", getIsDeleted())
            .append("createdAt", getCreatedAt())
            .append("updatedAt", getUpdatedAt())
            .append("price", getPrice())
            .toString();
    }
}
