package com.soss.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.soss.common.core.domain.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * 轮播图对象 banner
 *
 * @author zxq
 * @date 2022-04-28
 */
@Data
public class SysBanner extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;
    /**
     * 图片url
     */
    private String image;
    /**
     * 页面url
     */
    private String page;
    /**
     * 类型：1-小程序，2-KDS，3-点单屏
     */
    private Integer type;
    /**
     * 目标：1-小程序首页，2-小程序我的，0-其它
     */
    private Integer target;
    /**
     * 省份列表
     */
    private String province;
    /**
     * 城市列表
     */
    private String city;
    /**
     * 区域列表
     */
    private String area;
    /**
     * 店铺id列表
     */
    private String shopIds;
    /**
     * 排序
     */
    private Integer sort;
    /**
     * 状态：0-在线，1-下线
     */
    private Integer state;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createdAt;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updatedAt;

}
