package com.soss.system.domain.po;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("轮播图请求类")
public class BannerPo {
    /** 主键 */
    private Long id;
    /**
     * 图片url
     */
    private String image;
    /**
     * 页面url
     */
    private String page;
    /**
     * 类型：1-小程序，2-KDS，3-点单屏
     */
    private Integer type;
    /**
     * 目标：1-小程序首页，2-小程序我的，0-其它
     */
    private Integer target;
    /**
     * 排序
     */
    private Integer sort;
    /**
     * 状态
     */
    private Integer state;

    @ApiModelProperty("可用省份列表，全国通用传 [0]")
    private String[] province;

    @ApiModelProperty("可用城市列表")
    private String[] city;

    @ApiModelProperty("可用区域列表")
    private String[] area;

    @ApiModelProperty("可用店铺ID列表")
    private Long[] shopIds;
}
