package com.soss.system.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@ApiModel
@Data
public class CouponUserVo {

    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty("用户ID")
    private String custId;

    @ApiModelProperty("用户名称")
    private String custName;

    @ApiModelProperty("用户号码")
    private String custPhone;

    @ApiModelProperty("关联订单id")
    private Long orderId;

    @ApiModelProperty("关联订单号")
    private String orderNo;

    @ApiModelProperty("优惠券名称")
    private String couponName;

    @ApiModelProperty("优惠券来源")
    private String source;

    @ApiModelProperty("类型：1领取 2 发放 3赠送")
    private Integer type;

    @ApiModelProperty("类型描述")
    private String typeDesc;

    @ApiModelProperty("优惠券领取时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime receiveTime;

    @ApiModelProperty("优惠券生效时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startTime;

    @ApiModelProperty("优惠券失效时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime expiredTime;

    @ApiModelProperty("优惠券状态")
    private Integer state;

    @ApiModelProperty("优惠券状态描述")
    private String stateDesc;
}
