package com.soss.system.mapper;

import com.soss.system.domain.CouponUser;
import com.soss.system.domain.vo.CouponUserVo;
import com.soss.system.domain.vo.CouponVo;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 用户领取优惠券记录表 Mapper 接口
 * </p>
 *
 * @author caiyt
 * @since 2022-07-21
 */
public interface CouponUserMapper {
    /**
     * 获取优惠券被领取次数
     *
     * @param couponId
     * @return
     */
    long getCouponReceiveCount(@Param("couponId") Integer couponId);

    /**
     * 查询用户的优惠券信息
     *
     * @return
     */
    CouponUser getUserCouponById(@Param("id") Integer id);

    /**
     * 保存用户领取优惠券记录
     *
     * @param couponUser
     * @return
     */
    int insertCouponUser(CouponUser couponUser);

    /**
     * 更新用户领取优惠券记录
     *
     * @param couponUser
     * @return
     */
    int updateCouponUser(CouponUser couponUser);

    /**
     * 查询用户可用优惠券数量
     *
     * @param custId
     * @param nowTime
     * @return
     */
    int getCustAvailableCouponCnt(@Param("custId") String custId, @Param("nowTime") LocalDateTime nowTime, @Param("couponUserId") Integer couponUserId);

    /**
     * 查询用户可用优惠券列表
     *
     * @param custId
     * @param nowTime
     * @return
     */
    List<CouponVo> listCustAvailableCoupon(@Param("custId") String custId, @Param("couponUserId") Integer couponUserId, @Param("nowTime") LocalDateTime nowTime);

    /**
     * 查询用户优惠券列表
     *
     * @param custId        用户id
     * @param effectiveFlag 有效标识 true-有效 false-已使用/已失效
     */
    List<CouponVo> listCustCoupons(@Param("custId") String custId, @Param("effectiveFlag") Boolean effectiveFlag);

    /**
     * 查询用户领取优惠券列表
     *
     * @param couponUser
     * @return
     */
    List<CouponUserVo> selectCouponUserList(CouponUser couponUser);

    /**
     * 用户优惠券到期失效
     */
    void expireCouponUser();

    /**
     * 查询用户领取的优惠券数量
     */
    Long getCustCouponCnt(@Param("custId") String custId, @Param("couponId") Integer couponId, @Param("startTime") LocalDateTime startTime);
}
