package com.soss.system.service;

import java.util.List;
import com.soss.system.domain.SpecRule;

/**
 * 规格选项Service接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface ISpecRuleService 
{
    /**
     * 查询规格选项
     * 
     * @param id 规格选项主键
     * @return 规格选项
     */
    public SpecRule selectSpecRuleById(String id);

    /**
     * 查询规格选项列表
     * 
     * @param specRule 规格选项
     * @return 规格选项集合
     */
    public List<SpecRule> selectSpecRuleList(SpecRule specRule);

    /**
     * 新增规格选项
     * 
     * @param specRule 规格选项
     * @return 结果
     */
    public int insertSpecRule(SpecRule specRule);

    /**
     * 修改规格选项
     * 
     * @param specRule 规格选项
     * @return 结果
     */
    public int updateSpecRule(SpecRule specRule);

    /**
     * 批量删除规格选项
     * 
     * @param ids 需要删除的规格选项主键集合
     * @return 结果
     */
    public int deleteSpecRuleByIds(String[] ids);

    /**
     * 删除规格选项信息
     * 
     * @param id 规格选项主键
     * @return 结果
     */
    public int deleteSpecRuleById(String id);
}
